/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public interface Constraint {
    public static final Constraint ALLOWED = Constraint.from("ALLOWED", Authorization.ALLOWED, new String[0]);
    public static final Constraint FORBIDDEN = Constraint.from("FORBIDDEN", Authorization.FORBIDDEN, new String[0]);
    public static final Constraint ANY_USER = Constraint.from("ANY_USER", Authorization.ANY_USER, new String[0]);
    public static final Constraint KNOWN_ROLE = Constraint.from("KNOWN_ROLE", Authorization.KNOWN_ROLE, new String[0]);
    public static final Constraint SECURE_TRANSPORT = Constraint.from("SECURE", Transport.SECURE);
    public static final Constraint ANY_TRANSPORT = Constraint.from("ANY", Transport.ANY);
    public static final Constraint ALLOWED_ANY_TRANSPORT = Constraint.combine("ALLOWED_ANY_TRANSPORT", ALLOWED, ANY_TRANSPORT);

    public String getName();

    public Transport getTransport();

    public Authorization getAuthorization();

    public Set<String> getRoles();

    public static Constraint combine(Constraint leastSpecific, Constraint mostSpecific) {
        return Constraint.combine(null, leastSpecific, mostSpecific);
    }

    public static Constraint combine(String name, Constraint leastSpecific, Constraint mostSpecific) {
        if (leastSpecific == null) {
            return mostSpecific == null ? ALLOWED : mostSpecific;
        }
        if (mostSpecific == null) {
            return leastSpecific;
        }
        return Constraint.from(name, mostSpecific.getTransport() == Transport.INHERIT ? leastSpecific.getTransport() : mostSpecific.getTransport(), mostSpecific.getAuthorization() == Authorization.INHERIT ? leastSpecific.getAuthorization() : mostSpecific.getAuthorization(), mostSpecific.getAuthorization() == Authorization.INHERIT ? leastSpecific.getRoles() : mostSpecific.getRoles());
    }

    public static Constraint from(String ... roles) {
        return Constraint.from(null, Authorization.SPECIFIC_ROLE, roles);
    }

    public static Constraint from(String name, Transport transport) {
        return Constraint.from(name, transport, null, null);
    }

    public static Constraint from(String name, Authorization authorization, String ... roles) {
        return Constraint.from(name, Transport.INHERIT, authorization, roles == null || roles.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.stream(roles).toList()));
    }

    public static Constraint from(Transport transport, Authorization authorization, Set<String> roles) {
        return Constraint.from(null, transport, authorization, roles);
    }

    public static Constraint from(final String name, final Transport transport, final Authorization authorization, final Set<String> roles) {
        return new Constraint(){
            private final String _name;
            private final Transport _transport;
            private final Set<String> _roles;
            private final Authorization _authorization;
            {
                this._name = name == null ? "unnamed@%x".formatted(this.hashCode()) : name;
                this._transport = transport == null ? Transport.INHERIT : transport;
                Set<Object> set2 = this._roles = roles == null || roles.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(roles);
                Authorization authorization2 = authorization == null ? (this._roles.isEmpty() ? Authorization.INHERIT : Authorization.SPECIFIC_ROLE) : (this._authorization = authorization);
                if (!this._roles.isEmpty() && this._authorization != Authorization.SPECIFIC_ROLE) {
                    throw new IllegalStateException("Constraint with roles must be SPECIFIC_ROLE, not " + this._authorization);
                }
            }

            @Override
            public String getName() {
                return this._name;
            }

            @Override
            public Transport getTransport() {
                return this._transport;
            }

            @Override
            public Authorization getAuthorization() {
                return this._authorization;
            }

            @Override
            public Set<String> getRoles() {
                return this._roles;
            }

            public String toString() {
                return "Constraint@%x{%s,%s,%s,%s}".formatted(new Object[]{this.hashCode(), this.getName(), this.getTransport(), this.getAuthorization(), this.getRoles()});
            }
        };
    }

    public static enum Transport {
        SECURE,
        ANY,
        INHERIT;

    }

    public static enum Authorization {
        FORBIDDEN,
        ALLOWED,
        ANY_USER,
        KNOWN_ROLE,
        SPECIFIC_ROLE,
        INHERIT;

    }

    public static class Builder {
        private String _name;
        private Authorization _authorization;
        private Set<String> _roles;
        private Transport _transport;

        public Builder() {
        }

        public Builder(Constraint constraint) {
            this._transport = constraint.getTransport();
            this._authorization = constraint.getAuthorization();
            this._roles = constraint.getRoles();
        }

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public String getName() {
            return this._name;
        }

        public Builder transport(Transport transport) {
            this._transport = transport;
            return this;
        }

        public Transport getTransport() {
            return this._transport;
        }

        public Builder authorization(Authorization authorization) {
            this._authorization = authorization;
            return this;
        }

        public Authorization getAuthorization() {
            return this._authorization;
        }

        public Builder roles(String ... roles) {
            if (roles != null && roles.length > 0) {
                if (this._roles == null) {
                    this._roles = new HashSet<String>();
                } else if (!(this._roles instanceof HashSet)) {
                    this._roles = new HashSet<String>(this._roles);
                }
                this._roles.addAll(Arrays.asList(roles));
            }
            return this;
        }

        public Set<String> getRoles() {
            return this._roles == null ? Collections.emptySet() : this._roles;
        }

        public Constraint build() {
            return Constraint.from(this._name, this._transport, this._authorization, this._roles);
        }
    }
}

