/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.flightrecorder.JfrAttributes;

public class AttributeSelection
extends Action
implements IMenuCreator {
    public static final String SAMPLES = "Samples";
    public static final String ATTRIBUTE_SELECTION_ID = "AttributeSelection";
    public static final String ATTRIBUTE_SELECTION_SEP_ID = "AttrSelectionSep";
    private Menu menu;
    private final Collection<Pair<String, IAttribute<IQuantity>>> items;
    private final Supplier<IAttribute<IQuantity>> getCurrentAttr;
    private final Consumer<IAttribute<IQuantity>> setCurrentAttr;
    private final Runnable onSet;

    public static List<Pair<String, IAttribute<IQuantity>>> extractAttributes(IItemCollection items) {
        HashSet<Pair> compatibleAttr = new HashSet<Pair>();
        for (IItemIterable eventIterable : items) {
            List attributes = eventIterable.getType().getAttributes();
            if (!eventIterable.getType().hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_STACKTRACE)) continue;
            for (IAttribute attr : attributes) {
                ContentType contentType = attr.getContentType();
                if (contentType != UnitLookup.NUMBER && contentType != UnitLookup.MEMORY) continue;
                compatibleAttr.add(new Pair((Object)attr.getName(), (Object)attr));
            }
        }
        ArrayList<Pair<String, IAttribute<IQuantity>>> sortedList = new ArrayList<Pair<String, IAttribute<IQuantity>>>(compatibleAttr);
        sortedList.sort(Comparator.comparing(p -> (String)p.left));
        sortedList.add(0, new Pair((Object)SAMPLES, null));
        sortedList.add(1, new Pair((Object)"---", null));
        return sortedList;
    }

    public AttributeSelection(Collection<Pair<String, IAttribute<IQuantity>>> items, String attrName, Supplier<IAttribute<IQuantity>> getCurrentAttr, Consumer<IAttribute<IQuantity>> setCurrentAttr, Runnable onSet) {
        super(attrName != null ? attrName : SAMPLES, 4);
        this.setId(ATTRIBUTE_SELECTION_ID);
        this.items = items;
        this.getCurrentAttr = getCurrentAttr;
        this.setCurrentAttr = setCurrentAttr;
        this.onSet = onSet;
        this.setMenuCreator(this);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            this.populate(this.items);
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            this.populate(this.items);
        }
        return this.menu;
    }

    private void populate(Collection<Pair<String, IAttribute<IQuantity>>> attributes) {
        for (Pair<String, IAttribute<IQuantity>> item : attributes) {
            if (((String)item.left).equals("---")) {
                new Separator().fill(this.menu, 1);
                continue;
            }
            ActionContributionItem actionItem = new ActionContributionItem((IAction)new SetAttribute(item, item.right == this.getCurrentAttr.get()));
            actionItem.fill(this.menu, -1);
        }
    }

    private class SetAttribute
    extends Action {
        private IAttribute<IQuantity> value;

        SetAttribute(Pair<String, IAttribute<IQuantity>> item, boolean isSelected) {
            super((String)item.left, 8);
            this.value = (IAttribute)item.right;
            this.setChecked(isSelected);
        }

        public void run() {
            if (this.value != AttributeSelection.this.getCurrentAttr.get()) {
                AttributeSelection.this.setCurrentAttr.accept(this.value);
                AttributeSelection.this.onSet.run();
            }
        }
    }
}

