/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.exceptions;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanSquare;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ExceptionRule
implements IRule {
    private static final String RESULT_ID = "Exceptions";
    public static final TypedPreference<IQuantity> EXCEPTIONS_INFO_LIMIT = new TypedPreference("exception.info.limit", Messages.getString("ExceptionRule_CONFIG_INFO_LIMIT"), Messages.getString("ExceptionRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(5000L));
    public static final TypedPreference<IQuantity> EXCEPTIONS_WARNING_LIMIT = new TypedPreference("exception.warning.limit", Messages.getString("ExceptionRule_CONFIG_WARN_LIMIT"), Messages.getString("ExceptionRule_CONFIG_WARN_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(10000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(EXCEPTIONS_INFO_LIMIT, EXCEPTIONS_WARNING_LIMIT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ExceptionStatistics", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<IQuantity> EXCEPTION_RATE = new TypedResult("exceptionsRate", "Exception Rate", "The rate of exceptions thrown per minute.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IRange<IQuantity>> EXCEPTION_WINDOW = new TypedResult("exceptionsWindow", "Exception Window", "The window during which the highest exception rate was detected.", UnitLookup.TIMERANGE);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, EXCEPTION_RATE, EXCEPTION_WINDOW);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        long infoLimit = ((IQuantity)vp.getPreferenceValue(EXCEPTIONS_INFO_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        long warningLimit = ((IQuantity)vp.getPreferenceValue(EXCEPTIONS_WARNING_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        SpanSquare maxExceptionPeriod = SpanToolkit.getMaxCountCluster(items.apply(JdkFilters.THROWABLES_STATISTICS), (IAttribute<IQuantity>)JdkAttributes.EXCEPTION_THROWABLES_COUNT, (IAttribute<IQuantity>)JfrAttributes.EVENT_TIMESTAMP);
        if (maxExceptionPeriod != null) {
            double duration = (double)(maxExceptionPeriod.end - maxExceptionPeriod.start) / 1.0E9;
            double exPerSec = (double)maxExceptionPeriod.mass / duration;
            double score = RulesToolkit.mapExp100((double)exPerSec, (double)infoLimit, (double)warningLimit);
            IRange window = QuantityRange.createWithEnd((IQuantity)UnitLookup.EPOCH_NS.quantity(maxExceptionPeriod.start), (IQuantity)UnitLookup.EPOCH_NS.quantity(maxExceptionPeriod.end));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("ExceptionRule_TEXT_MESSAGE")).setExplanation(Messages.getString("ExceptionRule_TEXT_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(EXCEPTION_RATE, (Object)UnitLookup.NUMBER_UNITY.quantity(exPerSec)).addResult(TypedResult.ITEM_QUERY, (Object)JdkQueries.THROWABLES_STATISTICS).addResult(EXCEPTION_WINDOW, (Object)window).build();
        }
        return RulesToolkit.getTooFewEventsResult((IRule)this, (IPreferenceValueProvider)vp);
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return ExceptionRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ExceptionRule_RULE_NAME");
    }

    public String getTopic() {
        return "exceptions";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

