/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.batch;

import java.util.Comparator;
import java.util.List;
import org.openjdk.jmc.joverflow.support.ClassAndOvhdCombo;
import org.openjdk.jmc.joverflow.support.ClassAndSizeCombo;
import org.openjdk.jmc.joverflow.support.PrimitiveArrayWrapper;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.support.ReferenceChain;
import org.openjdk.jmc.joverflow.util.ClassUtils;
import org.openjdk.jmc.joverflow.util.MemNumFormatter;
import org.openjdk.jmc.joverflow.util.MiscUtils;
import org.openjdk.jmc.joverflow.util.ObjectToIntMap;
import org.openjdk.jmc.joverflow.util.SmallSet;

public abstract class ReferencedObjCluster {
    private final RefChainElement referer;
    private final int totalOverhead;
    public static final Comparator<ReferencedObjCluster> DEFAULT_COMPARATOR = new Comparator<ReferencedObjCluster>(){

        @Override
        public int compare(ReferencedObjCluster o1, ReferencedObjCluster o2) {
            int ovhdDiff = o2.getTotalOverhead() - o1.getTotalOverhead();
            if (ovhdDiff != 0) {
                return ovhdDiff;
            }
            int badObjNumDiff = o2.getNumBadObjects() - o1.getNumBadObjects();
            if (badObjNumDiff != 0) {
                return badObjNumDiff;
            }
            String thisRefChain = ReferenceChain.toStringInReverseOrder(o1.referer, 100);
            String otherRefChain = ReferenceChain.toStringInReverseOrder(o2.referer, 100);
            return thisRefChain.compareTo(otherRefChain);
        }
    };

    ReferencedObjCluster(RefChainElement referer, int totalOverhead) {
        this.referer = referer;
        this.totalOverhead = totalOverhead;
    }

    public int getTotalOverhead() {
        return this.totalOverhead;
    }

    public abstract int getNumBadObjects();

    public RefChainElement getReferer() {
        return this.referer;
    }

    public abstract String clusterAsString(MemNumFormatter var1);

    public static class Collections
    extends ReferencedObjCluster {
        private final List<ClassAndOvhdCombo> classAndOvhdList;
        private final int numGoodCollections;

        public Collections(RefChainElement referer, List<ClassAndOvhdCombo> classAndOvhdList, int totalOverhead, int numGoodCollections) {
            super(referer, totalOverhead);
            this.classAndOvhdList = classAndOvhdList;
            this.numGoodCollections = numGoodCollections;
        }

        public List<ClassAndOvhdCombo> getList() {
            return this.classAndOvhdList;
        }

        @Override
        public int getNumBadObjects() {
            int numObjects = 0;
            for (ClassAndOvhdCombo combo : this.classAndOvhdList) {
                numObjects += combo.getNumInstances();
            }
            return numObjects;
        }

        public int getNumGoodCollections() {
            return this.numGoodCollections;
        }

        @Override
        public String clusterAsString(MemNumFormatter nf) {
            StringBuilder buf = new StringBuilder(48);
            buf.append(nf.getNumInKAndPercent(this.getTotalOverhead())).append(":");
            String prevCollectionClassName = null;
            for (ClassAndOvhdCombo entry : this.classAndOvhdList) {
                if (!entry.getClazz().getName().equals(prevCollectionClassName)) {
                    buf.append(' ').append(entry.getClazz().getHumanFriendlyName()).append(": ");
                } else {
                    buf.append(", ");
                }
                prevCollectionClassName = entry.getClazz().getName();
                buf.append(entry.getNumInstances()).append(" of ");
                buf.append(entry.getProblemKind().name()).append(' ');
                buf.append(nf.getNumInKAndPercent(entry.getOverhead()));
            }
            if (this.numGoodCollections > 0) {
                buf.append(", ").append(this.numGoodCollections).append(" good collections");
            }
            return buf.toString();
        }
    }

    public static class DupArrays
    extends ReferencedObjCluster {
        private final int numNonDupArrays;
        private final ObjectToIntMap.Entry<PrimitiveArrayWrapper>[] entries;

        public DupArrays(RefChainElement referer, int totalOverhead, int numNonDupArrays, ObjectToIntMap.Entry<PrimitiveArrayWrapper>[] entries) {
            super(referer, totalOverhead);
            this.numNonDupArrays = numNonDupArrays;
            this.entries = entries;
        }

        public ObjectToIntMap.Entry<PrimitiveArrayWrapper>[] getEntries() {
            return this.entries;
        }

        @Override
        public int getNumBadObjects() {
            int result = 0;
            ObjectToIntMap.Entry<PrimitiveArrayWrapper>[] entryArray = this.entries;
            int n = this.entries.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectToIntMap.Entry<PrimitiveArrayWrapper> entry = entryArray[n2];
                result += entry.value;
                ++n2;
            }
            return result;
        }

        public int getNumNonDupArrays() {
            return this.numNonDupArrays;
        }

        @Override
        public String clusterAsString(MemNumFormatter nf) {
            int nUniqueArrays = this.entries.length;
            int nAllArrays = this.getNumBadObjects();
            StringBuilder buf = new StringBuilder(64);
            buf.append(nf.getNumInKAndPercent(this.getTotalOverhead()));
            buf.append(' ').append(nAllArrays).append(" dup arrays (");
            buf.append(nUniqueArrays).append(" unique)");
            if (this.numNonDupArrays > 0) {
                buf.append(", ").append(this.numNonDupArrays).append(" nondup arrays");
            }
            buf.append(":\n");
            String s = null;
            int len = 0;
            int count = 0;
            ObjectToIntMap.Entry<PrimitiveArrayWrapper>[] entryArray = this.entries;
            int n = this.entries.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectToIntMap.Entry<PrimitiveArrayWrapper> entry = entryArray[n2];
                if (s != null) {
                    buf.append(", ");
                    if ((len += s.length() + 2) > 70) {
                        buf.append('\n');
                        len = 0;
                    }
                }
                s = ((PrimitiveArrayWrapper)entry.key).getArray().valueAsString();
                buf.append(entry.value).append(" of ").append(s);
                if (++count >= 10) {
                    int nRemainingStringGroups = this.entries.length - count;
                    int nTotalRemainingStrings = 0;
                    int i = count;
                    while (i < this.entries.length) {
                        nTotalRemainingStrings += this.entries[i].value;
                        ++i;
                    }
                    if (nTotalRemainingStrings <= 0) break;
                    buf.append("\n... and ");
                    buf.append(nTotalRemainingStrings);
                    buf.append(" more arrays, of which ");
                    buf.append(nRemainingStringGroups);
                    buf.append(" are unique");
                    break;
                }
                ++n2;
            }
            return buf.toString();
        }
    }

    public static class DupStrings
    extends ReferencedObjCluster {
        private static final boolean PRINT_LONG_STRINGS_FULLY = false;
        private static final boolean PRINT_ALL_STRINGS = false;
        private final int numDupBackingCharArrays;
        private final int numNonDupStrings;
        private final ObjectToIntMap.Entry<String>[] entries;

        public DupStrings(RefChainElement referer, int totalOverhead, int numDupBackingCharArrays, int numNonDupStrings, ObjectToIntMap.Entry<String>[] entries) {
            super(referer, totalOverhead);
            this.numDupBackingCharArrays = numDupBackingCharArrays;
            this.numNonDupStrings = numNonDupStrings;
            this.entries = entries;
        }

        public ObjectToIntMap.Entry<String>[] getEntries() {
            return this.entries;
        }

        @Override
        public int getNumBadObjects() {
            int result = 0;
            int i = 0;
            while (i < this.entries.length) {
                result += this.entries[i].value;
                ++i;
            }
            return result;
        }

        public int getNumDupBackingCharArrays() {
            return this.numDupBackingCharArrays;
        }

        public int getNumNonDupStrings() {
            return this.numNonDupStrings;
        }

        @Override
        public String clusterAsString(MemNumFormatter nf) {
            int nUniqueStrings = this.entries.length;
            int nAllStrings = this.getNumBadObjects();
            StringBuilder buf = new StringBuilder(64);
            buf.append(nf.getNumInKAndPercent(this.getTotalOverhead()));
            buf.append(' ').append(nAllStrings).append(" dup strings (");
            buf.append(nUniqueStrings).append(" unique)");
            buf.append(", ").append(this.numDupBackingCharArrays).append(" dup backing arrays");
            if (this.numNonDupStrings > 0) {
                buf.append(", ").append(this.numNonDupStrings).append(" nondup strings");
            }
            buf.append(":\n");
            String s = null;
            int len = 0;
            int count = 0;
            ObjectToIntMap.Entry<String>[] entryArray = this.entries;
            int n = this.entries.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectToIntMap.Entry<String> entry = entryArray[n2];
                if (s != null) {
                    buf.append(", ");
                    if ((len += s.length() + 2) > 70) {
                        buf.append('\n');
                        len = 0;
                    }
                }
                s = (String)entry.key;
                int maxLen = 80;
                s = MiscUtils.removeEndLinesAndAddQuotes(s, maxLen);
                buf.append(entry.value).append(" of ").append(s);
                if (++count >= 10) {
                    int nRemainingStringGroups = this.entries.length - count;
                    int nTotalRemainingStrings = 0;
                    int i = count;
                    while (i < this.entries.length) {
                        nTotalRemainingStrings += this.entries[i].value;
                        ++i;
                    }
                    if (nTotalRemainingStrings <= 0) break;
                    buf.append("\n... and ");
                    buf.append(nTotalRemainingStrings);
                    buf.append(" more strings, of which ");
                    buf.append(nRemainingStringGroups);
                    buf.append(" are unique");
                    break;
                }
                ++n2;
            }
            return buf.toString();
        }
    }

    public static class HighSizeObjects
    extends ReferencedObjCluster {
        private final List<ClassAndSizeCombo> classAndSizeList;

        public HighSizeObjects(RefChainElement referer, List<ClassAndSizeCombo> classAndSizeList, int totalSize) {
            super(referer, totalSize);
            this.classAndSizeList = classAndSizeList;
        }

        public List<ClassAndSizeCombo> getList() {
            return this.classAndSizeList;
        }

        @Override
        public int getNumBadObjects() {
            int numObjects = 0;
            for (ClassAndSizeCombo combo : this.classAndSizeList) {
                numObjects += combo.getNumInstances();
            }
            return numObjects;
        }

        @Override
        public String clusterAsString(MemNumFormatter nf) {
            StringBuilder buf = new StringBuilder(48);
            buf.append(nf.getNumInKAndPercent(this.getTotalOverhead())).append(":");
            boolean first = true;
            for (ClassAndSizeCombo entry : this.classAndSizeList) {
                if (!first) {
                    buf.append(',');
                }
                first = false;
                buf.append(' ').append(entry.getClazz().getHumanFriendlyName()).append(": ");
                buf.append(entry.getNumInstances()).append(" instances ");
                buf.append(nf.getNumInKAndPercent(entry.getSizeOrOvhd()));
            }
            return buf.toString();
        }
    }

    public static class WeakHashMaps
    extends ReferencedObjCluster {
        private final int numInstances;
        private final SmallSet<String> colClasses;
        private final SmallSet<String> valueTypeAndFieldSamples;

        public WeakHashMaps(RefChainElement referer, int numInstances, int totalOverhead, SmallSet<String> colClasses, SmallSet<String> valueTypeAndFieldSamples) {
            super(referer, totalOverhead);
            this.numInstances = numInstances;
            this.colClasses = colClasses;
            this.valueTypeAndFieldSamples = valueTypeAndFieldSamples;
        }

        public String[] getClasses() {
            return (String[])this.colClasses.getElements(String[].class);
        }

        public String[] getBackRefs() {
            return (String[])this.valueTypeAndFieldSamples.getElements(String[].class);
        }

        @Override
        public int getNumBadObjects() {
            return this.numInstances;
        }

        @Override
        public String clusterAsString(MemNumFormatter nf) {
            StringBuilder buf = new StringBuilder(64);
            String[] classes = (String[])this.colClasses.getElements(String[].class);
            int i = 0;
            while (i < classes.length) {
                classes[i] = ClassUtils.getShortNameForPopularClass(classes[i]);
                ++i;
            }
            String[] valueTypesAndFields = (String[])this.valueTypeAndFieldSamples.getElements(String[].class);
            buf.append(nf.getNumInKAndPercent(this.getTotalOverhead())).append(' ');
            buf.append(this.numInstances).append(" of ");
            buf.append(MiscUtils.asCommaSeparatedList(classes)).append(' ');
            buf.append("have back refs from: ");
            buf.append(MiscUtils.asCommaSeparatedList(valueTypesAndFields));
            return buf.toString();
        }
    }
}

