/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.joverflow.heap.model.HeapStringReader;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.stats.LengthHistogram;
import org.openjdk.jmc.joverflow.support.CompressibleStringStats;
import org.openjdk.jmc.joverflow.support.DupStringStats;
import org.openjdk.jmc.joverflow.support.NumberEncodingStringStats;
import org.openjdk.jmc.joverflow.support.ShortArrayStats;

class StringStatsCollector {
    private final HeapStringReader stringReader;
    private int stringInstShallowSize;
    private int nTotalStrings;
    private int numBackingCharArrays;
    private final HashMap<String, InternalEntry> table;
    private int currentId = 1;
    private int nZeroLengthStrings;
    private int n1Strings;
    private int n4Strings;
    private int n8Strings;
    private int nCompressedStrings;
    private int nAsciiCharBackedStrings;
    private long usedBackingArrayBytes;
    private long compressedBackingArrayBytes;
    private long asciiCharBackingArrayBytes;
    private int nStringsEncodingInts;
    private long stringsEncodingIntsOvhd;
    private LengthHistogram.Builder lenHistoBuilder;

    StringStatsCollector(Snapshot snapshot) {
        this.stringReader = snapshot.getStringReader();
        int capacity = snapshot.getNumObjects() / 4;
        this.table = new HashMap(capacity);
        this.lenHistoBuilder = new LengthHistogram.Builder(capacity);
    }

    String add(JavaObject strObj) {
        String strVal;
        ++this.nTotalStrings;
        if (this.stringInstShallowSize == 0) {
            this.stringInstShallowSize = strObj.getSize();
        }
        if ((strVal = this.stringReader.readString(strObj)) == null) {
            return null;
        }
        InternalEntry entry = this.table.get(strVal);
        if (entry == null) {
            entry = new InternalEntry(this.currentId++);
            this.table.put(strVal, entry);
        }
        strObj.setInternalId(entry.uniqueId);
        ++entry.nStringInst;
        JavaValueArray backingArray = this.stringReader.getLastReadBackingArray();
        boolean arrayNotSeenBefore = !backingArray.isVisitedAsCollectionImpl();
        int backingArraySize = 0;
        if (arrayNotSeenBefore) {
            backingArray.setVisitedAsCollectionImpl();
            ++this.numBackingCharArrays;
            ++entry.nBackingArrs;
            backingArraySize = backingArray.getSize();
            entry.totalBackingArrSize += backingArraySize;
            int arrayLen = backingArray.getLength();
            if (arrayLen > entry.maxArrayLen) {
                entry.maxArrayLen = arrayLen;
            }
        }
        int strLen = strVal.length();
        if (backingArray.getClazz().isByteArray()) {
            ++this.nCompressedStrings;
            if (arrayNotSeenBefore) {
                this.usedBackingArrayBytes += (long)strLen;
                this.compressedBackingArrayBytes += (long)strLen;
            }
        } else {
            if (arrayNotSeenBefore) {
                this.usedBackingArrayBytes += (long)(strLen * 2);
            }
            boolean compressible = true;
            int i = 0;
            while (i < strVal.length()) {
                if (strVal.charAt(i) > '\u00ff') {
                    compressible = false;
                    break;
                }
                ++i;
            }
            if (compressible) {
                ++this.nAsciiCharBackedStrings;
                if (arrayNotSeenBefore) {
                    this.asciiCharBackingArrayBytes += (long)(strLen * 2);
                }
            }
        }
        this.checkForShortString(strVal);
        if (this.isEncodedIntNumber(strVal)) {
            ++this.nStringsEncodingInts;
            this.stringsEncodingIntsOvhd += (long)(this.stringInstShallowSize + backingArraySize - 4);
        }
        this.lenHistoBuilder.addInstance(strLen, this.stringInstShallowSize + backingArraySize);
        return strVal;
    }

    public DupStringStats getDuplicationStats() {
        ArrayList<DupStringStats.Entry> dupStringList = new ArrayList<DupStringStats.Entry>(this.table.size() / 20);
        long dupStringsOvhd = 0L;
        for (Map.Entry<String, InternalEntry> tableEntry : this.table.entrySet()) {
            InternalEntry ie = tableEntry.getValue();
            if (ie == null || ie.nStringInst == 1) {
                tableEntry.setValue(null);
                continue;
            }
            int overhead = (ie.nStringInst - 1) * this.stringInstShallowSize;
            if (ie.nBackingArrs > 1) {
                overhead += (int)((long)ie.totalBackingArrSize * (long)(ie.nBackingArrs - 1) / (long)ie.nBackingArrs);
            }
            dupStringList.add(new DupStringStats.Entry(tableEntry.getKey(), ie.uniqueId, ie.nStringInst, ie.nBackingArrs, ie.maxArrayLen, overhead));
            dupStringsOvhd += (long)overhead;
        }
        dupStringList.sort(new Comparator<DupStringStats.Entry>(){

            @Override
            public int compare(DupStringStats.Entry e1, DupStringStats.Entry e2) {
                return e2.overhead - e1.overhead;
            }
        });
        return new DupStringStats(this.stringInstShallowSize, this.nTotalStrings, this.table.size(), this.numBackingCharArrays, dupStringList, dupStringsOvhd);
    }

    public ShortArrayStats getShortStringStats() {
        long strShallowSize = this.stringInstShallowSize;
        return new ShortArrayStats(this.nZeroLengthStrings, strShallowSize * (long)this.nZeroLengthStrings, this.n1Strings, strShallowSize * (long)this.n1Strings, this.n4Strings, strShallowSize * (long)this.n4Strings, this.n8Strings, strShallowSize * (long)this.n8Strings);
    }

    public CompressibleStringStats getCompressibleStringStats() {
        return new CompressibleStringStats(this.nTotalStrings, this.numBackingCharArrays, this.usedBackingArrayBytes, this.nCompressedStrings, this.compressedBackingArrayBytes, this.nAsciiCharBackedStrings, this.asciiCharBackingArrayBytes);
    }

    public NumberEncodingStringStats getNumberEncodingStringStats() {
        return new NumberEncodingStringStats(this.nStringsEncodingInts, this.stringsEncodingIntsOvhd);
    }

    public LengthHistogram getLengthHistogram() {
        return this.lenHistoBuilder.build();
    }

    private void checkForShortString(String string) {
        int strLen = string.length();
        if (strLen == 0) {
            ++this.nZeroLengthStrings;
        } else if (strLen == 1) {
            ++this.n1Strings;
        } else if (strLen <= 4) {
            ++this.n4Strings;
        } else if (strLen <= 8) {
            ++this.n8Strings;
        }
    }

    private boolean isEncodedIntNumber(String s) {
        if (s.isEmpty()) {
            return false;
        }
        int result = 0;
        int i = 0;
        int len = s.length();
        int limit = -2147483647;
        char firstChar = s.charAt(0);
        if (firstChar < '0') {
            if (firstChar == '-') {
                limit = Integer.MIN_VALUE;
            } else if (firstChar != '+') {
                return false;
            }
            if (len == 1) {
                return false;
            }
            ++i;
        }
        int multmin = limit / 10;
        while (i < len) {
            int digit;
            if ((digit = StringStatsCollector.getDigitFromChar(s.charAt(i++))) < 0) {
                return false;
            }
            if (result < multmin) {
                return false;
            }
            if ((result *= 10) < limit + digit) {
                return false;
            }
            result -= digit;
        }
        return true;
    }

    private static int getDigitFromChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    private static class InternalEntry {
        final int uniqueId;
        int nStringInst;
        int nBackingArrs;
        int totalBackingArrSize;
        private int maxArrayLen;

        InternalEntry(int uniqueId) {
            this.uniqueId = uniqueId;
        }
    }
}

