/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace.graph;

import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;

public final class AggregatableFrame
implements IMCFrame {
    private final FrameSeparator separator;
    private final IMCFrame frame;

    public AggregatableFrame(FrameSeparator separator, IMCFrame frame) {
        if (separator == null) {
            throw new NullPointerException("Separator must not be null");
        }
        if (frame == null) {
            throw new NullPointerException("Frame must not be null");
        }
        this.separator = separator;
        this.frame = frame;
    }

    public Integer getFrameLineNumber() {
        return this.frame.getFrameLineNumber();
    }

    public Integer getBCI() {
        return this.frame.getBCI();
    }

    public IMCMethod getMethod() {
        return this.frame.getMethod();
    }

    public IMCFrame.Type getType() {
        return this.frame.getType();
    }

    public int hashCode() {
        switch (this.separator.getCategorization()) {
            case LINE: {
                return this.frame.getMethod().hashCode() + 31 * this.frame.getFrameLineNumber();
            }
            case METHOD: {
                return this.frame.getMethod().hashCode();
            }
            case CLASS: {
                return this.frame.getMethod().getType().hashCode();
            }
            case PACKAGE: {
                return this.frame.getMethod().getType().getPackage().hashCode();
            }
        }
        return this.frame.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregatableFrame other = (AggregatableFrame)obj;
        return !this.separator.isSeparate(this.frame, other.frame);
    }

    public String toString() {
        return FormatToolkit.getHumanReadable((IMCMethod)this.getMethod()) + ":" + this.separator.getCategorization();
    }

    public String getHumanReadableSeparatorSensitiveString() {
        switch (this.separator.getCategorization()) {
            case LINE: {
                return FormatToolkit.getHumanReadable((IMCMethod)this.getMethod()) + ":" + this.frame.getFrameLineNumber();
            }
            case METHOD: {
                return FormatToolkit.getHumanReadable((IMCMethod)this.getMethod());
            }
            case CLASS: {
                return this.frame.getMethod().getType().getFullName();
            }
            case PACKAGE: {
                return this.frame.getMethod().getType().getPackage().getName();
            }
        }
        return FormatToolkit.getHumanReadable((IMCMethod)this.getMethod()) + ":" + this.frame.getFrameLineNumber() + "(" + this.getBCI() + ")";
    }

    public String getHumanReadableShortString() {
        return FormatToolkit.getHumanReadable((IMCMethod)this.getMethod(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
    }
}

