/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree.traversal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;
import org.openjdk.jmc.flightrecorder.rules.tree.ItemTreeToolkit;
import org.openjdk.jmc.flightrecorder.rules.tree.traversal.BFIterator;
import org.openjdk.jmc.flightrecorder.rules.tree.traversal.LayerBreakdownVisitor;

public class LayerBreakdownGenerator {
    private Map<Integer, LayerBreakdownVisitor.LayerBreakdown> layersMap = new HashMap<Integer, LayerBreakdownVisitor.LayerBreakdown>();
    private final ITreeNode<IItem> startNode;

    public LayerBreakdownGenerator(ITreeNode<IItem> startNode) {
        this.startNode = startNode;
        this.calculateLayers(startNode);
    }

    private void calculateLayers(ITreeNode<IItem> startNode) {
        BFIterator<IItem> iter = new BFIterator<IItem>(startNode);
        while (iter.hasNext()) {
            ITreeNode next = (ITreeNode)iter.next();
            this.processPayload((IItem)next.getValue(), ItemTreeToolkit.getDepth(next));
        }
    }

    protected void processPayload(IItem value, int level) {
        Integer layer = level;
        LayerBreakdownVisitor.LayerBreakdown breakdown = this.layersMap.get(layer);
        if (breakdown == null) {
            breakdown = new LayerBreakdownVisitor.LayerBreakdown(level);
            this.layersMap.put(layer, breakdown);
        }
        if (value != null) {
            breakdown.add(value);
        }
    }

    public List<LayerBreakdownVisitor.LayerBreakdown> getLayers() {
        ArrayList<LayerBreakdownVisitor.LayerBreakdown> layers = new ArrayList<LayerBreakdownVisitor.LayerBreakdown>();
        layers.addAll(this.layersMap.values());
        layers.sort(LayerBreakdownVisitor.BREAKDOWN_COMPARATOR);
        return layers;
    }

    public ITreeNode<IItem> getStartNode() {
        return this.startNode;
    }
}

