/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.contribution;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.console.agent.contribution.CreateMethodProbeDialog;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.console.agent.manager.model.PresetRepository;
import org.openjdk.jmc.console.agent.manager.model.PresetRepositoryFactory;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.idesupport.ObjectContributionMenuSelectionListener;

public class CreateMethodProbeHandler
extends ObjectContributionMenuSelectionListener {
    private static Logger logger = Logger.getLogger(CreateMethodProbeHandler.class.getName());

    public void execute(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.getFirstElement() instanceof IMCMethod) {
                IMCMethod method = (IMCMethod)AdapterUtil.getAdapter((Object)((IStructuredSelection)selection).getFirstElement(), IMCMethod.class);
                this.createMethodProbe(method);
            } else if (structuredSelection.getFirstElement() instanceof StacktraceFrame) {
                StacktraceFrame frame = (StacktraceFrame)structuredSelection.getFirstElement();
                this.createMethodProbe(frame.getFrame().getMethod());
            }
        }
    }

    private void createMethodProbe(IMCMethod method) {
        PresetRepository repository = PresetRepositoryFactory.createSingleton();
        IPreset preset = repository.createPreset();
        IEvent event = preset.createEvent();
        preset.setFileName(method.getMethodName() + ".xml");
        event.setMethodName(method.getMethodName());
        event.setMethodDescriptor(method.getFormalDescriptor());
        event.setClazz(method.getType().getFullName());
        event.setLocation(IEvent.Location.WRAP);
        preset.addEvent(event);
        this.openUserDialog(preset);
        preset.save();
        try {
            repository.addPreset(preset);
        }
        catch (IOException e) {
            logger.severe(e.toString());
        }
    }

    private void openUserDialog(IPreset preset) {
        Shell shell = Display.getCurrent().getActiveShell();
        Dialog dialog = CreateMethodProbeDialog.create(shell, preset);
        dialog.setBlockOnOpen(true);
        dialog.open();
    }
}

