/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.wizards;

import java.util.Locale;
import java.util.stream.Stream;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;

public class EventEditingWizardConfigPage
extends BaseWizardPage {
    private final IEvent event;
    private Text idText;
    private Text nameText;
    private Text descriptionText;
    private Text classText;
    private Text methodNameText;
    private Text methodDescriptorText;
    private Text pathText;
    private Combo locationCombo;
    private Button locationClearButton;
    private Button recordExceptionsButton;
    private Button recordStackTraceButton;

    protected EventEditingWizardConfigPage(IEvent event) {
        super(Messages.EventEditingWizardConfigPage_PAGE_NAME);
        this.event = event;
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(Messages.EventEditingWizardConfigPage_MESSAGE_EVENT_EDITING_WIZARD_CONFIG_PAGE_TITLE);
        this.setDescription(Messages.EventEditingWizardConfigPage_MESSAGE_EVENT_EDITING_WIZARD_CONFIG_PAGE_DESCRIPTION);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createConfigContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        EventEditingWizardConfigPage.createSeparator(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.createInstrumentationTargetContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        EventEditingWizardConfigPage.createSeparator(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.createMetaInfoContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.bindListeners();
        this.populateUi();
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
    }

    private Composite createConfigContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 5;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.idText = EventEditingWizardConfigPage.createTextInput(container, cols, Messages.EventEditingWizardConfigPage_LABEL_ID, Messages.EventEditingWizardConfigPage_MESSAGE_EVENT_ID);
        this.nameText = EventEditingWizardConfigPage.createTextInput(container, cols, Messages.EventEditingWizardConfigPage_LABEL_NAME, Messages.EventEditingWizardConfigPage_MESSAGE_NAME_OF_THE_EVENT);
        this.descriptionText = EventEditingWizardConfigPage.createMultiTextInput(container, cols, Messages.EventEditingWizardConfigPage_LABEL_DESCRIPTION, Messages.EventEditingWizardConfigPage_MESSAGE_OPTIONAL_DESCRIPTION_OF_THIS_EVENT);
        return container;
    }

    private Composite createInstrumentationTargetContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 8;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.classText = EventEditingWizardConfigPage.createTextInput(container, cols, Messages.EventEditingWizardConfigPage_LABEL_CLASS, Messages.EventEditingWizardConfigPage_MESSAGE_FULLY_QUALIFIED_CLASS_NAME);
        Text[] receivers = EventEditingWizardConfigPage.createMultiInputTextInput(container, cols, Messages.EventEditingWizardConfigPage_LABEL_METHOD, new String[]{Messages.EventEditingWizardConfigPage_MESSAGE_METHOD_NAME, Messages.EventEditingWizardConfigPage_MESSAGE_METHOD_DESCRIPTOR});
        this.methodNameText = receivers[0];
        this.methodDescriptorText = receivers[1];
        return container;
    }

    private Composite createMetaInfoContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 8;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.pathText = EventEditingWizardConfigPage.createTextInput(container, cols, Messages.EventEditingWizardConfigPage_LABEL_PATH, Messages.EventEditingWizardConfigPage_MESSAGE_PATH_TO_EVENT);
        this.locationCombo = EventEditingWizardConfigPage.createComboInput(container, cols - 2, Messages.EventEditingWizardConfigPage_LABEL_LOCATION, (String[])Stream.of(IEvent.Location.values()).map(Enum::toString).toArray(String[]::new));
        this.locationClearButton = EventEditingWizardConfigPage.createButton(container, Messages.EventEditingWizardConfigPage_LABEL_CLEAR);
        this.locationClearButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 0));
        this.recordExceptionsButton = EventEditingWizardConfigPage.createCheckboxInput(container, cols, Messages.EventEditingWizardConfigPage_LABEL_RECORD_EXCEPTIONS);
        this.recordStackTraceButton = EventEditingWizardConfigPage.createCheckboxInput(container, cols, Messages.EventEditingWizardConfigPage_LABEL_RECORD_STACK_TRACE);
        return container;
    }

    private void bindListeners() {
        this.idText.addModifyListener(this.handleExceptionIfAny(e -> this.event.setId(this.idText.getText())));
        this.nameText.addModifyListener(this.handleExceptionIfAny(e -> this.event.setName(this.nameText.getText())));
        this.descriptionText.addModifyListener(this.handleExceptionIfAny(e -> this.event.setDescription(this.descriptionText.getText())));
        this.methodNameText.addModifyListener(this.handleExceptionIfAny(e -> this.event.setMethodName(this.methodNameText.getText())));
        this.methodDescriptorText.addModifyListener(this.handleExceptionIfAny(e -> this.event.setMethodDescriptor(this.methodDescriptorText.getText())));
        this.pathText.addModifyListener(this.handleExceptionIfAny(e -> this.event.setPath(this.pathText.getText())));
        this.classText.addModifyListener(this.handleExceptionIfAny(e -> this.event.setClazz(this.classText.getText())));
        this.locationCombo.addModifyListener(this.handleExceptionIfAny(e -> this.event.setLocation(this.locationCombo.getSelectionIndex() == -1 ? null : IEvent.Location.valueOf(this.locationCombo.getText().toUpperCase(Locale.ENGLISH)))));
        this.locationClearButton.addListener(13, e -> this.locationCombo.deselectAll());
        this.recordExceptionsButton.addListener(13, this.handleExceptionIfAny(e -> this.event.setRethrow(this.recordExceptionsButton.getSelection())));
        this.recordStackTraceButton.addListener(13, this.handleExceptionIfAny(e -> this.event.setStackTrace(this.recordStackTraceButton.getSelection())));
    }

    private void populateUi() {
        EventEditingWizardConfigPage.setText(this.idText, this.event.getId());
        EventEditingWizardConfigPage.setText(this.nameText, this.event.getName());
        EventEditingWizardConfigPage.setText(this.descriptionText, this.event.getDescription());
        EventEditingWizardConfigPage.setText(this.classText, this.event.getClazz());
        EventEditingWizardConfigPage.setText(this.methodNameText, this.event.getMethodName());
        EventEditingWizardConfigPage.setText(this.methodDescriptorText, this.event.getMethodDescriptor());
        EventEditingWizardConfigPage.setText(this.pathText, this.event.getPath());
        EventEditingWizardConfigPage.setText(this.locationCombo, this.event.getLocation() == null ? null : this.event.getLocation().toString());
        this.recordExceptionsButton.setSelection(this.event.getRethrow());
        this.recordStackTraceButton.setSelection(this.event.getStackTrace());
    }
}

