/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.RequestType;
import org.json.simple.JSONObject;

public class JolokiaExecRequest
extends JolokiaObjectNameRequest {
    private final String operation;
    private final List<?> arguments;

    JolokiaExecRequest(String pObjectName, String pOperation, List<?> pArguments, ProcessingParameters pParams) throws MalformedObjectNameException {
        super(RequestType.EXEC, pObjectName, null, pParams, true);
        this.operation = pOperation;
        this.arguments = pArguments;
    }

    JolokiaExecRequest(Map<String, ?> pRequestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
        super(pRequestMap, pParams, true);
        this.arguments = (List)pRequestMap.get("arguments");
        this.operation = (String)pRequestMap.get("operation");
    }

    public String getOperation() {
        return this.operation;
    }

    public List<?> getArguments() {
        return this.arguments;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        if (this.arguments != null && !this.arguments.isEmpty()) {
            ret.put((Object)"arguments", this.arguments);
        }
        ret.put((Object)"operation", (Object)this.operation);
        return ret;
    }

    static RequestCreator<JolokiaExecRequest> newCreator() {
        return new RequestCreator<JolokiaExecRequest>(){

            @Override
            public JolokiaExecRequest create(Stack<String> pStack, ProcessingParameters pParams) throws MalformedObjectNameException {
                return new JolokiaExecRequest(pStack.pop(), pStack.pop(), JolokiaExecRequest.convertSpecialStringTags(this.prepareExtraArgs(pStack)), pParams);
            }

            @Override
            public JolokiaExecRequest create(Map<String, ?> requestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
                return new JolokiaExecRequest(requestMap, pParams);
            }
        };
    }

    private static List<String> convertSpecialStringTags(List<String> extraArgs) {
        if (extraArgs == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : extraArgs) {
            args.add(EscapeUtil.convertSpecialStringTags(arg));
        }
        return args;
    }

    public String toString() {
        String baseInfo;
        StringBuilder ret = new StringBuilder("JmxExecRequest[");
        ret.append("operation=").append(this.getOperation());
        if (this.arguments != null && !this.arguments.isEmpty()) {
            ret.append(", arguments=").append(this.getArguments());
        }
        if ((baseInfo = this.getInfo()) != null) {
            ret.append(", ").append(baseInfo);
        }
        ret.append("]");
        return ret.toString();
    }
}

