/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.flamegraph.FrameBox;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameModel<T> {
    public static final FrameModel<?> EMPTY = new FrameModel(Collections.emptyList());
    @NotNull
    public final String title;
    @NotNull
    public final @NotNull List<@NotNull FrameBox<@NotNull T>> frames;
    @NotNull
    public final @NotNull FrameEquality<@NotNull T> frameEquality;
    @Nullable
    public String description;

    public FrameModel(@NotNull @NotNull List<@NotNull FrameBox<@NotNull T>> frames) {
        this("", (a, b) -> Objects.equals(a.actualNode, b.actualNode), frames);
    }

    public FrameModel(@NotNull String title, @NotNull @NotNull FrameEquality<@NotNull T> frameEquality, @NotNull @NotNull List<@NotNull FrameBox<@NotNull T>> frames) {
        this.title = Objects.requireNonNull(title, "title");
        this.frames = Objects.requireNonNull(frames, "frames");
        this.frameEquality = Objects.requireNonNull(frameEquality, "frameEquality");
    }

    @NotNull
    public static <T> @NotNull FrameModel<@NotNull T> empty() {
        return EMPTY;
    }

    @NotNull
    public @NotNull FrameModel<@NotNull T> withDescription(@NotNull String description) {
        this.description = Objects.requireNonNull(description, "description");
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameModel that = (FrameModel)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.frames, that.frames) && Objects.equals(this.frameEquality, that.frameEquality) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.frames, this.frameEquality, this.description);
    }

    public static interface FrameEquality<T> {
        public boolean equal(FrameBox<@NotNull T> var1, FrameBox<@NotNull T> var2);
    }
}

