/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common;

import java.net.MalformedURLException;
import javax.management.remote.JMXServiceURL;
import org.openjdk.jmc.common.security.ICredentials;
import org.openjdk.jmc.common.security.InMemoryCredentials;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;
import org.openjdk.jmc.rjmx.common.IConnectionDescriptor;
import org.openjdk.jmc.rjmx.common.internal.JMXConnectionDescriptor;

public class ConnectionDescriptorBuilder {
    private JMXServiceURL url;
    private String hostName;
    private String username;
    private String password;
    private int port = -1;
    private ICredentials credentials;
    public static final int DEFAULT_PORT = -1;

    public ConnectionDescriptorBuilder url(JMXServiceURL url) {
        this.url = url;
        return this;
    }

    public ConnectionDescriptorBuilder hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public ConnectionDescriptorBuilder port(int port) {
        this.port = port;
        return this;
    }

    public ConnectionDescriptorBuilder credentials(ICredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public ConnectionDescriptorBuilder username(String username) {
        this.username = username;
        return this;
    }

    public ConnectionDescriptorBuilder password(String password) {
        this.password = password;
        return this;
    }

    public IConnectionDescriptor build() throws IllegalStateException {
        if (this.credentials == null && this.username != null && this.password != null) {
            this.credentials = new InMemoryCredentials(this.username, this.password);
        }
        if (this.url == null && this.hostName == null) {
            throw new IllegalStateException("You must specify either the url or the host!");
        }
        if (this.url == null) {
            try {
                this.url = ConnectionToolkit.createServiceURL(this.hostName, this.port);
            }
            catch (MalformedURLException e) {
                IllegalStateException exception = new IllegalStateException("Could not create a proper JMXServiceURL with the provided information.");
                exception.initCause(e);
                throw exception;
            }
        }
        return new JMXConnectionDescriptor(this.url, this.credentials);
    }
}

