/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IXYDisplayableSet;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;

public abstract class XYQuantities<P>
implements IXYDisplayableSet<P, IQuantity> {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.ui.charts");
    private final P payload;
    protected final SubdividedQuantityRange xRange;
    protected IQuantity maxY;
    protected IQuantity minY;
    protected SubdividedQuantityRange yRange;

    public static <T> XYQuantities<T> create(T payload, double[] numericalYValues, IUnit yUnit, SubdividedQuantityRange xRange) {
        return new DoubleStored<T>(payload, numericalYValues, yUnit, xRange);
    }

    public static <T> XYQuantities<T> create(T payload, List<IQuantity> yValues, SubdividedQuantityRange xRange) {
        return new QuantityStored<T>(payload, yValues, xRange);
    }

    public static <T> XYQuantities<T> create(T payload, List<IQuantity> xValues, List<IQuantity> yValues, SubdividedQuantityRange xRange) {
        return new XYStored<T>(payload, xValues, yValues, xRange);
    }

    protected XYQuantities(P payload, SubdividedQuantityRange xRange) {
        this.payload = payload;
        this.xRange = xRange;
    }

    public void setYRange(SubdividedQuantityRange yRange) {
        this.yRange = yRange;
    }

    @Override
    public abstract int getSize();

    public int floorIndexAtX(double x) {
        return this.xRange.getFloorSubdividerAtPixel(x);
    }

    @Override
    public double getPixelX(int index) {
        return this.xRange.getSubdividerPixel(index);
    }

    @Override
    public abstract double getPixelY(int var1);

    @Override
    public IQuantity getDisplayableX(int index) {
        return this.xRange.getSubdivider(index);
    }

    @Override
    public abstract IQuantity getDisplayableY(int var1);

    public IQuantity getMaxY() {
        return this.maxY;
    }

    public IQuantity getMinY() {
        return this.minY;
    }

    @Override
    public int getWidth() {
        return this.xRange.getPixelExtent();
    }

    @Override
    public int getHeight() {
        return this.yRange.getPixelExtent();
    }

    public SubdividedQuantityRange getXRange() {
        return this.xRange;
    }

    public SubdividedQuantityRange getYRange() {
        return this.yRange;
    }

    @Override
    public P getPayload() {
        return this.payload;
    }

    public static abstract class AbstractSpan
    implements IChartInfoVisitor.ISpan,
    Cloneable {
        protected int index;
        private final Point2D offset;

        public AbstractSpan(int index, Point2D offset) {
            this.index = index;
            this.offset = offset;
        }

        @Override
        public IChartInfoVisitor.ISpan keeper() {
            try {
                return (IChartInfoVisitor.ISpan)this.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.log(Level.SEVERE, "Failed to clone span", e);
                return this;
            }
        }

        protected abstract XYQuantities<?> getXYSet();

        protected abstract int getHeight();

        @Override
        public abstract Color getColor();

        @Override
        public Rectangle2D getTarget() {
            XYQuantities<?> set = this.getXYSet();
            int x1 = Math.max(-1000000, (int)set.getPixelX(this.index));
            int x2 = Math.min(1000000, (int)set.getPixelY(this.index));
            return new Rectangle2D.Double(this.offset.getX() + (double)x1, this.offset.getY(), x2 - x1, this.getHeight() - 1);
        }

        @Override
        public IDisplayable getRange() {
            return QuantityRange.createInfinite((IQuantity)this.getStartX(), (IQuantity)this.getEndX());
        }

        public IQuantity getStartX() {
            return this.getXYSet().getDisplayableX(this.index);
        }

        public IQuantity getEndX() {
            return this.getXYSet().getDisplayableY(this.index);
        }

        public IQuantity getWidth() {
            IQuantity start = this.getStartX();
            IQuantity end = this.getEndX();
            return start != null && end != null ? end.subtract(start) : null;
        }

        @Override
        public Object getPayload() {
            Object payload = this.getXYSet().getPayload();
            if (payload != null) {
                if (payload.getClass().isArray()) {
                    return this.index < Array.getLength(payload) ? Array.get(payload, this.index) : null;
                }
                if (payload instanceof List) {
                    List list = (List)payload;
                    return this.index < list.size() ? list.get(this.index) : null;
                }
            }
            return payload;
        }
    }

    public static class Bucket
    implements IChartInfoVisitor.IBucket {
        private final XYQuantities<?> set;
        protected int index;
        private final Point2D offset;
        private final String name;
        private final Color color;

        public Bucket(XYQuantities<?> set, int index, Point2D offset, String name, Color color) {
            this.set = set;
            this.index = index;
            this.offset = offset;
            this.name = name;
            this.color = color;
        }

        @Override
        public IChartInfoVisitor.IBucket keeper() {
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        protected XYQuantities<?> getXYSet() {
            return this.set;
        }

        @Override
        public Rectangle2D getTarget() {
            double x1 = this.set.getPixelX(this.index);
            int w = (int)this.set.getPixelX(this.index + 1) - (int)x1;
            int y = (int)this.set.getPixelY(this.index);
            return new Rectangle2D.Double(this.offset.getX() + this.set.getPixelX(this.index), this.offset.getY() + (double)this.set.getHeight() - 1.0 - (double)y, w, y);
        }

        @Override
        public IDisplayable getRange() {
            return QuantityRange.createWithEnd((IQuantity)this.set.getDisplayableX(this.index), (IQuantity)this.set.getDisplayableX(this.index + 1));
        }

        public IQuantity getStartX() {
            return this.getXYSet().getDisplayableX(this.index);
        }

        public IQuantity getEndX() {
            return this.getXYSet().getDisplayableX(this.index + 1);
        }

        public IQuantity getWidth() {
            return this.getEndX().subtract(this.getStartX());
        }

        public IQuantity getY() {
            return this.getXYSet().getDisplayableY(this.index);
        }

        @Override
        public Object getPayload() {
            Object payload = this.getXYSet().getPayload();
            if (payload != null) {
                if (payload.getClass().isArray()) {
                    return this.index < Array.getLength(payload) ? Array.get(payload, this.index) : null;
                }
                if (payload instanceof List) {
                    List list = (List)payload;
                    return this.index < list.size() ? list.get(this.index) : null;
                }
            }
            return payload;
        }
    }

    private static class DoubleStored<T>
    extends XYQuantities<T> {
        private final double[] yValues;
        private final IUnit yUnit;
        private IScalarAffineTransform yUnitToPixel;

        private DoubleStored(T payload, double[] yValues, IUnit yUnit, SubdividedQuantityRange xRange) {
            super(payload, xRange);
            this.yUnit = yUnit;
            double maxY = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double[] dArray = yValues;
            int n = yValues.length;
            int n2 = 0;
            while (n2 < n) {
                double yValue = dArray[n2];
                double y = yValue;
                if (!Double.isNaN(y)) {
                    if (y > maxY) {
                        maxY = y;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                }
                ++n2;
            }
            if (yUnit == null || maxY < minY) {
                this.yValues = new double[0];
                this.maxY = null;
                this.minY = null;
            } else {
                this.yValues = yValues;
                this.maxY = yUnit.quantity(maxY);
                this.minY = yUnit.quantity(minY);
            }
        }

        @Override
        public void setYRange(SubdividedQuantityRange yRange) {
            super.setYRange(yRange);
            this.yUnitToPixel = yRange.toPixelTransform(this.yUnit);
        }

        @Override
        public int getSize() {
            return this.yValues.length;
        }

        @Override
        public double getPixelY(int index) {
            double yValue = this.yValues[index];
            return this.yUnitToPixel.targetValue(Double.isNaN(yValue) ? 0.0 : yValue);
        }

        @Override
        public IQuantity getDisplayableY(int index) {
            double yValue = this.yValues[index];
            return Double.isNaN(yValue) ? null : this.yUnit.quantity(yValue);
        }
    }

    public static class Point
    implements IChartInfoVisitor.IPoint {
        private final XYQuantities<?> set;
        protected int index;
        private final Point2D offset;
        private final String name;
        private final Color color;

        public Point(XYQuantities<?> set, int index, Point2D offset, String name, Color color) {
            this.set = set;
            this.index = index;
            this.offset = offset;
            this.name = name;
            this.color = color;
        }

        @Override
        public IChartInfoVisitor.IPoint keeper() {
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public Point2D getTarget() {
            int y = (int)this.offset.getY() + this.set.getHeight() - 1 - (int)this.set.getPixelY(this.index);
            return new Point2D.Double(this.offset.getX() + this.set.getPixelX(this.index), y);
        }

        public IQuantity getX() {
            return this.set.getDisplayableX(this.index);
        }

        public IQuantity getY() {
            return this.set.getDisplayableY(this.index);
        }
    }

    private static class QuantityStored<T>
    extends XYQuantities<T> {
        private final List<IQuantity> yValues;

        private QuantityStored(T payload, List<IQuantity> yValues, SubdividedQuantityRange xRange) {
            super(payload, xRange);
            IQuantity maxY = null;
            IQuantity minY = null;
            for (IQuantity y : yValues) {
                if (y == null) continue;
                if (maxY == null) {
                    maxY = y;
                    minY = y;
                    continue;
                }
                if (y.compareTo((Object)maxY) > 0) {
                    maxY = y;
                }
                if (y.compareTo((Object)minY) >= 0) continue;
                minY = y;
            }
            if (maxY == null) {
                this.yValues = Collections.emptyList();
                this.maxY = null;
                this.minY = null;
            } else {
                this.yValues = yValues;
                this.maxY = maxY;
                this.minY = minY;
            }
        }

        @Override
        public int getSize() {
            return this.yValues.size();
        }

        @Override
        public double getPixelY(int index) {
            return this.yRange.getPixel(this.yValues.get(index));
        }

        @Override
        public IQuantity getDisplayableY(int index) {
            return this.yValues.get(index);
        }
    }

    private static class XYStored<T>
    extends QuantityStored<T> {
        private final List<IQuantity> xValues;

        private XYStored(T payload, List<IQuantity> xValues, List<IQuantity> yValues, SubdividedQuantityRange xRange) {
            super(payload, yValues, xRange);
            this.xValues = xValues;
            assert (xValues.size() == yValues.size());
        }

        @Override
        public int floorIndexAtX(double x) {
            double nextX = Math.floor(x) + 1.0;
            int index = Collections.binarySearch(this.xValues, this.xRange.getQuantityAtPixel(nextX));
            if (index < 0) {
                index = -index - 1;
            }
            return index - 1;
        }

        @Override
        public double getPixelX(int index) {
            return this.xRange.getPixel(this.xValues.get(index));
        }

        @Override
        public IQuantity getDisplayableX(int index) {
            return this.xValues.get(index);
        }
    }
}

