/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.Messages;
import org.openjdk.jmc.ui.misc.PatternFly;

public class TimeFilter
extends Composite {
    public static final String START_TIME_NAME = "timefilter.startTime.text.name";
    public static final String END_TIME_NAME = "timefilter.endTime.text.name";
    public static final String dateFormat = "yyyy-MM-dd ";
    public static final String timeFormat = "HH:mm:ss:SSS";
    private boolean isMultiDayRecording = false;
    public Calendar calendar;
    private ChartCanvas chartCanvas;
    private XYChart chart;
    private SimpleDateFormat sdf;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd ");
    private TimeDisplay startDisplay;
    private TimeDisplay endDisplay;

    public TimeFilter(Composite parent, IRange<IQuantity> recordingRange, Listener resetListener) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(7, false));
        this.inspectRecordingRange(recordingRange);
        Label eventsLabel = new Label((Composite)this, 16384);
        eventsLabel.setText(Messages.TimeFilter_FILTER_EVENTS);
        eventsLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        Label fromLabel = new Label((Composite)this, 0x1000000);
        fromLabel.setText(Messages.TimeFilter_FROM);
        this.startDisplay = new TimeDisplay(this, FilterType.START, (IQuantity)recordingRange.getStart());
        Label toLabel = new Label((Composite)this, 0x1000000);
        toLabel.setText(Messages.TimeFilter_TO);
        this.endDisplay = new TimeDisplay(this, FilterType.END, (IQuantity)recordingRange.getEnd());
        Button resetBtn = new Button((Composite)this, 8);
        resetBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        resetBtn.setText(Messages.TimeFilter_RESET);
        resetBtn.addListener(13, resetListener);
    }

    private void inspectRecordingRange(IRange<IQuantity> recordingRange) {
        long firstDateEpoch = ((IQuantity)recordingRange.getStart()).in((IUnit)UnitLookup.EPOCH_MS).longValue();
        long secondDateEpoch = ((IQuantity)recordingRange.getEnd()).in((IUnit)UnitLookup.EPOCH_MS).longValue();
        boolean bl = this.isMultiDayRecording = !this.dateFormatter.format(firstDateEpoch).equals(this.dateFormatter.format(secondDateEpoch));
        if (!this.isMultiDayRecording) {
            this.calendar = Calendar.getInstance();
            this.calendar.setTimeInMillis(firstDateEpoch);
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
            this.calendar.set(13, 0);
            this.calendar.set(14, 0);
            this.calendar.add(14, this.calendar.getTimeZone().getRawOffset());
        }
    }

    protected void updateRange() {
        this.chart.setVisibleRange(this.startDisplay.getCurrentTime(), this.endDisplay.getCurrentTime());
        this.chartCanvas.redrawChart();
    }

    public void setChart(XYChart chart) {
        this.chart = chart;
    }

    public void setChartCanvas(ChartCanvas canvas) {
        this.chartCanvas = canvas;
    }

    public void setStartTime(IQuantity time) {
        this.startDisplay.setTime(time);
    }

    public void setEndTime(IQuantity time) {
        this.endDisplay.setTime(time);
    }

    private static enum FilterType {
        START,
        END;

    }

    private class TimeDisplay
    extends Composite {
        private boolean bypassModifyListener;
        private FilterType type;
        private int lastEventTime;
        private IQuantity defaultTime;
        private IQuantity currentTime;
        private Text timeText;

        public TimeDisplay(final TimeFilter parent, FilterType type, IQuantity defaultTime) {
            super((Composite)parent, 0);
            this.type = type;
            this.defaultTime = defaultTime;
            this.setLayout((Layout)new GridLayout());
            this.timeText = new Text((Composite)this, 132);
            this.timeText.setData("name", (Object)(type == FilterType.START ? TimeFilter.START_TIME_NAME : TimeFilter.END_TIME_NAME));
            if (!TimeFilter.this.isMultiDayRecording) {
                this.timeText.setTextLimit(12);
                TimeFilter.this.sdf = new SimpleDateFormat(TimeFilter.timeFormat);
            } else {
                this.timeText.setTextLimit(23);
                TimeFilter.this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            }
            this.timeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (TimeDisplay.this.getBypassModifyListener()) {
                        TimeDisplay.this.setBypassModifyListener(false);
                        return;
                    }
                    if (e.time == TimeDisplay.this.lastEventTime) {
                        return;
                    }
                    TimeDisplay.this.lastEventTime = e.time;
                    String newTimestring = TimeDisplay.this.timeText.getText();
                    if (!TimeDisplay.this.isValidSyntax(newTimestring)) {
                        return;
                    }
                    IQuantity newTime = TimeDisplay.this.convertStringToIQuantity(newTimestring);
                    if (TimeDisplay.this.currentTime == null || newTime == null) {
                        return;
                    }
                    if (TimeDisplay.this.isWithinRange(newTime)) {
                        TimeDisplay.this.timeText.setForeground(PatternFly.Palette.PF_BLACK.getSWTColor());
                        TimeDisplay.this.currentTime = newTime;
                        parent.updateRange();
                    } else {
                        TimeDisplay.this.timeText.setForeground(PatternFly.Palette.PF_RED_100.getSWTColor());
                    }
                }
            });
        }

        public void setTime(IQuantity time) {
            this.setBypassModifyListener(true);
            String timestring = TimeFilter.this.sdf.format(new Date(time.in((IUnit)UnitLookup.EPOCH_MS).longValue()));
            this.currentTime = time;
            this.timeText.setText(timestring);
            this.timeText.setForeground(PatternFly.Palette.PF_BLACK.getSWTColor());
            this.setBypassModifyListener(false);
        }

        private IQuantity convertStringToIQuantity(String timestring) {
            try {
                long parsedTime = TimeFilter.this.sdf.parse(timestring).getTime();
                if (!TimeFilter.this.isMultiDayRecording) {
                    parsedTime += TimeFilter.this.calendar.getTimeInMillis();
                }
                return UnitLookup.EPOCH_MS.quantity(parsedTime);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private boolean isWithinRange(IQuantity time) {
            if (time == null) {
                return false;
            }
            long timeMillis = time.in((IUnit)UnitLookup.EPOCH_MS).longValue();
            if (this.type == FilterType.START) {
                if (timeMillis < this.defaultTime.in((IUnit)UnitLookup.EPOCH_MS).longValue()) {
                    DialogToolkit.showWarning(this.getDisplay().getActiveShell(), Messages.TimeFilter_ERROR, Messages.TimeFilter_START_TIME_PRECEEDS_ERROR);
                    return false;
                }
                if (timeMillis > TimeFilter.this.endDisplay.getDefaultTime().in((IUnit)UnitLookup.EPOCH_MS).longValue() || timeMillis > TimeFilter.this.endDisplay.getCurrentTime().in((IUnit)UnitLookup.EPOCH_MS).longValue()) {
                    DialogToolkit.showWarning(this.getDisplay().getActiveShell(), Messages.TimeFilter_ERROR, Messages.TimeFilter_START_TIME_LONGER_THAN_END_ERROR);
                    TimeFilter.this.endDisplay.getDefaultTime().in((IUnit)UnitLookup.EPOCH_MS).longValue();
                    return false;
                }
            } else {
                if (timeMillis > this.defaultTime.in((IUnit)UnitLookup.EPOCH_MS).longValue()) {
                    DialogToolkit.showWarning(this.getDisplay().getActiveShell(), Messages.TimeFilter_ERROR, Messages.TimeFilter_END_TIME_EXCEEDS_ERROR);
                    return false;
                }
                if (timeMillis < TimeFilter.this.startDisplay.getDefaultTime().in((IUnit)UnitLookup.EPOCH_MS).longValue() || timeMillis < TimeFilter.this.startDisplay.getCurrentTime().in((IUnit)UnitLookup.EPOCH_MS).longValue()) {
                    DialogToolkit.showWarning(this.getDisplay().getActiveShell(), Messages.TimeFilter_ERROR, Messages.TimeFilter_START_TIME_LONGER_THAN_END_ERROR);
                    return false;
                }
            }
            return true;
        }

        private boolean isValidSyntax(String formattedTimestring) {
            if (formattedTimestring.length() != this.timeText.getTextLimit()) {
                return false;
            }
            try {
                TimeFilter.this.sdf.parse(formattedTimestring);
            }
            catch (ParseException parseException) {
                return false;
            }
            return true;
        }

        private IQuantity getDefaultTime() {
            return this.defaultTime;
        }

        private IQuantity getCurrentTime() {
            return this.currentTime;
        }

        private boolean getBypassModifyListener() {
            return this.bypassModifyListener;
        }

        private void setBypassModifyListener(boolean bypassModifyListener) {
            this.bypassModifyListener = bypassModifyListener;
        }
    }
}

