/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.object;

import javax.management.openmbean.OpenType;
import org.jolokia.service.serializer.object.OpenTypeDeserializer;
import org.json.simple.JSONAware;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

abstract class OpenTypeConverter<T extends OpenType> {
    protected boolean forgiving = false;
    private final OpenTypeDeserializer dispatcher;

    OpenTypeConverter(OpenTypeDeserializer pDispatcher) {
        this.dispatcher = pDispatcher;
    }

    abstract boolean canConvert(OpenType var1);

    abstract Object convertToObject(T var1, Object var2);

    protected JSONAware toJSON(Object pValue) {
        Class<?> givenClass = pValue.getClass();
        if (JSONAware.class.isAssignableFrom(givenClass)) {
            return (JSONAware)pValue;
        }
        try {
            return (JSONAware)new JSONParser().parse(pValue.toString());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse JSON " + pValue + ": " + e, e);
        }
        catch (ClassCastException exp) {
            throw new IllegalArgumentException("Given value " + pValue + " cannot be parsed to JSONAware object: " + exp, exp);
        }
    }

    protected OpenTypeDeserializer getDispatcher() {
        return this.dispatcher;
    }

    protected boolean isForgiving() {
        return this.forgiving || this.dispatcher != null && this.dispatcher.isForgiving();
    }
}

