/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.common.services.IServiceFactory;
import org.openjdk.jmc.rjmx.common.services.internal.ServiceEntry;

public class ServiceFactoryInitializer {
    private static final String EXTENSION_POINT = "org.openjdk.jmc.rjmx.service";
    private static final String EXTENSION_ELEMENT_SERVICE = "service";
    private static final String EXTENSION_ATTRIBUTE_FACTORY = "factory";
    private static final String EXTENSION_ATTRIBUTE_NAME = "name";
    private static final String EXTENSION_ATTRIBUTE_DESCRIPTION = "description";

    public static List<ServiceEntry<?>> initializeFromExtensions() {
        ArrayList serviceEntries = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (config.getName().equals(EXTENSION_ELEMENT_SERVICE)) {
                try {
                    IServiceFactory factory = (IServiceFactory)config.createExecutableExtension(EXTENSION_ATTRIBUTE_FACTORY);
                    serviceEntries.add(ServiceFactoryInitializer.createServiceEntry(factory, config));
                }
                catch (CoreException e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate service factory!", e);
                }
            }
            ++n2;
        }
        return serviceEntries;
    }

    private static <T> ServiceEntry<T> createServiceEntry(IServiceFactory<T> factory, IConfigurationElement config) {
        String name = config.getAttribute(EXTENSION_ATTRIBUTE_NAME);
        String description = config.getAttribute(EXTENSION_ATTRIBUTE_DESCRIPTION);
        return new ServiceEntry(factory, name, description);
    }
}

