/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Set;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmc.rjmx.common.subscription.internal.AttributeValueToolkit;
import org.openjdk.jmc.rjmx.subscription.internal.AbstractSyntheticAttribute;
import org.openjdk.jmc.rjmx.subscription.internal.SyntheticAttributeToolkit;

public class HotSpotLastGcAttribute
extends AbstractSyntheticAttribute {
    private static final String COM_SUN_MANAGEMENT_GC_NOTIFICATION = "com.sun.management.gc.notification";
    private MBeanServerConnection m_connection = null;
    private Set<ObjectName> m_garbageCollectorMxBeans;
    private final NotificationListener m_listener = this.createListener();
    private CompositeData m_lastGcInfo = null;

    public Object getValue(MBeanServerConnection connection) throws MBeanException, ReflectionException {
        return this.m_lastGcInfo;
    }

    public void setValue(MBeanServerConnection connection, Object value) throws MBeanException, ReflectionException {
    }

    @Override
    public void init(MBeanServerConnection connection) {
        super.init(connection);
        this.m_connection = connection;
        this.m_garbageCollectorMxBeans = SyntheticAttributeToolkit.lookupMxBeans(this.m_connection, "java.lang", "GarbageCollector");
        this.m_lastGcInfo = this.findLatestGcInfo(this.m_garbageCollectorMxBeans);
        SyntheticAttributeToolkit.subscribeToNotifications(this.m_connection, this.m_listener, this.m_garbageCollectorMxBeans, COM_SUN_MANAGEMENT_GC_NOTIFICATION);
    }

    @Override
    public void stop() {
        SyntheticAttributeToolkit.unsubscribeFromNotifications(this.m_connection, this.m_listener, this.m_garbageCollectorMxBeans);
    }

    private NotificationListener createListener() {
        return new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object handback) {
                HotSpotLastGcAttribute hotSpotLastGcAttribute = HotSpotLastGcAttribute.this;
                synchronized (hotSpotLastGcAttribute) {
                    HotSpotLastGcAttribute.this.m_lastGcInfo = (CompositeData)((CompositeData)notification.getUserData()).get("gcInfo");
                }
            }
        };
    }

    private CompositeData findLatestGcInfo(Set<ObjectName> garbageCollectorMxBeans) {
        long lastTimestamp = 0L;
        CompositeData lastLastGc = null;
        for (ObjectName objectName : garbageCollectorMxBeans) {
            try {
                long endTime;
                CompositeData lastGcInfo = (CompositeData)AttributeValueToolkit.getAttribute((MBeanServerConnection)this.m_connection, (ObjectName)objectName, (String)"LastGcInfo");
                if (lastGcInfo == null || (endTime = ((Long)lastGcInfo.get("endTime")).longValue()) <= lastTimestamp) continue;
                lastTimestamp = endTime;
                lastLastGc = lastGcInfo;
            }
            catch (Exception exception) {}
        }
        return lastLastGc;
    }

    public boolean hasResolvedDependencies(MBeanServerConnection connection) {
        return !SyntheticAttributeToolkit.lookupMxBeans(connection, "java.lang", "GarbageCollector").isEmpty();
    }
}

