/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.common.subscription.IMRITransformationFactory;
import org.openjdk.jmc.rjmx.common.subscription.internal.MRITransformationBaseToolkit;

public class MRITransformationToolkit
extends MRITransformationBaseToolkit {
    static {
        MRITransformationToolkit.initializeFromExtensions();
    }

    private MRITransformationToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    private static void initializeFromExtensions() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("org.openjdk.jmc.rjmx.attributeTransformation");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("attributeTransformation")) {
                    try {
                        IMRITransformationFactory transformationFactory = (IMRITransformationFactory)config.createExecutableExtension("class");
                        String transformationName = config.getAttribute("transformationName");
                        Properties props = new Properties();
                        Properties transProps = new Properties();
                        props.put("transformationName", transformationName);
                        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren();
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement prop = iConfigurationElementArray2[n6];
                            if (prop.getName().equals("property")) {
                                props.put(prop.getAttribute("name"), prop.getAttribute("value"));
                            } else if (prop.getName().equals("transformationProperties")) {
                                IConfigurationElement[] iConfigurationElementArray3 = prop.getChildren();
                                int n7 = iConfigurationElementArray3.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IConfigurationElement transProp = iConfigurationElementArray3[n8];
                                    if (transProp.getName().equals("property")) {
                                        transProps.put(transProp.getAttribute("name"), transProp.getAttribute("value"));
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                        transformationFactory.setFactoryProperties(props, transProps);
                        TRANSFORMATION_FACTORIES.put(transformationName, transformationFactory);
                    }
                    catch (CoreException e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate attribute transformation factory!", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

