/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.constraints.internal;

import java.util.Date;
import java.util.GregorianCalendar;
import org.openjdk.jmc.rjmx.triggers.TriggerConstraint;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;

public class TriggerConstraintTimeRange
extends TriggerConstraint {
    private static final String XML_ELEMENT_TIME_FROM = "from";
    private static final String XML_ELEMENT_TIME_TO = "to";

    @Override
    public boolean isValid(TriggerEvent e) {
        return this.validateTime(e.getCreationTime());
    }

    private boolean validateTime(Date validationDate) {
        int to;
        int now = TriggerConstraintTimeRange.minuteOfDay(validationDate);
        int from = TriggerConstraintTimeRange.minuteOfDay(this.getSetting(XML_ELEMENT_TIME_FROM).getDateTime());
        if (from <= (to = TriggerConstraintTimeRange.minuteOfDay(this.getSetting(XML_ELEMENT_TIME_TO).getDateTime()))) {
            return now >= from && now <= to;
        }
        return now >= from || now <= to;
    }

    private static int minuteOfDay(Date time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        return cal.get(11) * 60 + cal.get(12);
    }
}

