/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.internal;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.subscription.IMRIValueListener;
import org.openjdk.jmc.rjmx.common.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.common.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.triggers.IActivatableTriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationTrigger;

class NotificationRuleBag {
    private final Map<TriggerRule, IMRIValueListener> rules = new HashMap<TriggerRule, IMRIValueListener>();
    private WeakReference<IConnectionHandle> handleRef = new WeakReference<Object>(null);
    private final String serverGuid;

    public NotificationRuleBag(String serverGuid) {
        this.serverGuid = serverGuid;
    }

    void activate(IConnectionHandle handle) {
        assert (handle.getServerDescriptor().getGUID().equals(this.serverGuid));
        this.handleRef = new WeakReference<IConnectionHandle>(handle);
        Iterator<Map.Entry<TriggerRule, IMRIValueListener>> rulesIter = this.rules.entrySet().iterator();
        while (rulesIter.hasNext()) {
            Map.Entry<TriggerRule, IMRIValueListener> rule = rulesIter.next();
            if (this.activateRule(rule.getKey(), rule.getValue(), handle)) continue;
            rulesIter.remove();
        }
    }

    void deactivate() {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (IConnectionHandle handle = (IConnectionHandle)this.handleRef.get();){
                for (Map.Entry<TriggerRule, IMRIValueListener> rule : this.rules.entrySet()) {
                    this.deactivateRule(rule.getKey(), rule.getValue(), handle);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    Collection<TriggerRule> getAllRegisteredRules() {
        return this.rules.keySet();
    }

    boolean removeRule(TriggerRule r) {
        IMRIValueListener listener;
        if (r != null && r.getTrigger() != null && r.getTrigger().getAttributeDescriptor() != null && (listener = this.rules.remove(r)) != null) {
            this.deactivateRule(r, listener, (IConnectionHandle)this.handleRef.get());
            return true;
        }
        return false;
    }

    boolean addRule(final TriggerRule r) {
        if (r == null || r.getTrigger() == null || r.getTrigger().getAttributeDescriptor() == null || this.rules.containsKey(r)) {
            return false;
        }
        IMRIValueListener listener = new IMRIValueListener(){

            public void valueChanged(MRIValueEvent event) {
                r.getTrigger().triggerOn((IConnectionHandle)NotificationRuleBag.this.handleRef.get(), r, event);
            }
        };
        boolean activateOk = this.activateRule(r, listener, (IConnectionHandle)this.handleRef.get());
        this.rules.put(r, listener);
        return activateOk;
    }

    private boolean activateRule(TriggerRule r, IMRIValueListener listener, IConnectionHandle handle) {
        if (handle != null && handle.isConnected() && (!(r.getAction() instanceof IActivatableTriggerAction) || ((IActivatableTriggerAction)((Object)r.getAction())).isActivatable(handle))) {
            ((ISubscriptionService)handle.getServiceOrDummy(ISubscriptionService.class)).addMRIValueListener(r.getTrigger().getAttributeDescriptor(), listener);
            return true;
        }
        return false;
    }

    private void deactivateRule(TriggerRule r, IMRIValueListener listener, IConnectionHandle handle) {
        if (handle != null && handle.isConnected()) {
            ((ISubscriptionService)handle.getServiceOrDummy(ISubscriptionService.class)).removeMRIValueListener(listener);
        }
        if (r.getTrigger() instanceof NotificationTrigger) {
            r.getTrigger().clearState(this.serverGuid);
        }
    }
}

