/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.selection;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.JfrPropertySheet;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.FlavoredSelectionBase;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;

public class ItemBackedSelection
extends FlavoredSelectionBase {
    private final IItemCollection selectedItems;

    public ItemBackedSelection(IItemCollection selectedItems, String name) {
        super(name);
        this.selectedItems = selectedItems;
    }

    @Override
    public Stream<IItemStreamFlavor> getFlavors(IItemFilter filter, IItemCollection items, List<IAttribute<?>> dstAttributes) {
        boolean itemsApplicableOnPage = ItemCollectionToolkit.filterIfNotNull((IItemCollection)this.selectedItems, (IItemFilter)filter).hasItems();
        Stream.Builder<IItemStreamFlavor> builder = Stream.builder();
        IItemStreamFlavor selectedEventsFlavor = IItemStreamFlavor.build(MessageFormat.format(Messages.FLAVOR_SELECTED_EVENTS, ItemCollectionToolkit.getDescription((IItemCollection)this.selectedItems)), this.selectedItems);
        if (itemsApplicableOnPage) {
            builder.accept(selectedEventsFlavor);
        }
        IItemCollection dstItems = ItemCollectionToolkit.filterIfNotNull((IItemCollection)items, (IItemFilter)filter);
        JfrPropertySheet.calculatePersistableFilterFlavors(this.selectedItems, dstItems, items, dstAttributes).forEach(builder::accept);
        if (!itemsApplicableOnPage) {
            builder.accept(selectedEventsFlavor);
        }
        return builder.build();
    }
}

