/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.io.File;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.common.util.StatefulState;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.PagesExportWizard;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.wizards.SimpleImportFromFileWizardPage;

public class PagesImportWizard
extends Wizard
implements IImportWizard {
    private static String WIZARD_KEY = "importFlightRecordingPagesFromFile";
    private SimpleImportFromFileWizardPage wizardPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(FlightRecorderUI.getDefault().getDialogSettings());
        this.wizardPage = new SimpleImportFromFileWizardPage(WIZARD_KEY, "xml");
        this.wizardPage.setTitle(Messages.PAGE_IMPORT_WIZARD_TITLE);
        this.setWindowTitle(this.wizardPage.getTitle());
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        File file = this.wizardPage.getFile();
        if (file != null) {
            try {
                StatefulState persistedState = StatefulState.create((IStateful)StateToolkit.statefulFromXMLFile((File)file, (Charset)PagesExportWizard.CHARSET));
                FlightRecorderUI.getDefault().getPageManager().insertPages(Stream.of(persistedState.getChildren()));
                return true;
            }
            catch (RuntimeException e) {
                DialogToolkit.showExceptionDialogAsync((Display)this.wizardPage.getControl().getDisplay(), (String)Messages.PAGE_IMPORT_ERROR_TITLE, (String)MessageFormat.format(Messages.PAGE_IMPORT_ERROR_MESSAGE, e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return false;
    }
}

