/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.CoreImages;

public abstract class LabeledPageFactory
implements IDataPageFactory {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_ICON = "icon";

    @Override
    public String getName(IState state) {
        String name = state.getAttribute(ATTRIBUTE_NAME);
        return name != null ? name : this.getDefaultName(state);
    }

    protected String getDefaultName(IState state) {
        return Messages.PAGE_UNNAMED;
    }

    @Override
    public String getDescription(IState state) {
        return state.getAttribute(ATTRIBUTE_DESCRIPTION);
    }

    @Override
    public ImageDescriptor getImageDescriptor(IState state) {
        String iconStr = state.getAttribute(ATTRIBUTE_ICON);
        if (iconStr != null) {
            byte[] pngData = Base64.getDecoder().decode(iconStr);
            try {
                return ImageDescriptor.createFromImageDataProvider(zoom -> new ImageData((InputStream)new ByteArrayInputStream(pngData)));
            }
            catch (Exception e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not load icon for page: " + this.getName(state), e);
            }
        }
        return this.getDefaultImageDescriptor(state);
    }

    protected ImageDescriptor getDefaultImageDescriptor(IState state) {
        return CoreImages.HELP;
    }

    public static void writeLabel(IWritableState to, String name, String description, ImageDescriptor image) {
        to.putString(ATTRIBUTE_NAME, name);
        to.putString(ATTRIBUTE_DESCRIPTION, description);
        if (image != null) {
            try {
                ImageLoader loader = new ImageLoader();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                loader.data = new ImageData[]{image.getImageData(100)};
                loader.save((OutputStream)out, 5);
                String iconStr = Base64.getEncoder().encodeToString(out.toByteArray());
                to.putString(ATTRIBUTE_ICON, iconStr);
            }
            catch (Exception e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not persist icon", e);
            }
        }
    }
}

