/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import org.openjdk.jmc.joverflow.descriptors.AbstractArrayBasedCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.ArrayBasedCollectionDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaField;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.support.Constants;
import org.openjdk.jmc.joverflow.util.ClassUtils;

public class WeakHashMapDescriptor
extends ArrayBasedCollectionDescriptor
implements Constants {
    private static final JavaHeapObject[] EMPTY_ARRAY = new JavaHeapObject[0];

    private WeakHashMapDescriptor(JavaObject col, Factory factory) {
        super(col, factory);
    }

    public JavaHeapObject[][] getKeysAndValues() {
        int size = this.getNumElements();
        if (size <= 0) {
            return new JavaHeapObject[][]{EMPTY_ARRAY, EMPTY_ARRAY};
        }
        Factory f = (Factory)this.factory;
        JavaObjectArray entriesArray = this.getElementsArray();
        if (entriesArray == null) {
            return new JavaHeapObject[][]{EMPTY_ARRAY, EMPTY_ARRAY};
        }
        JavaHeapObject[] entries = entriesArray.getElements();
        JavaThing[] entryFields = null;
        JavaHeapObject[] keys = new JavaHeapObject[size];
        JavaHeapObject[] values = new JavaHeapObject[size];
        int entryIdx = 0;
        JavaHeapObject[] javaHeapObjectArray = entries;
        int n = entries.length;
        int n2 = 0;
        block0: while (n2 < n) {
            block6: {
                JavaHeapObject entryThing = javaHeapObjectArray[n2];
                if (entryThing != null && entryThing instanceof JavaObject) {
                    JavaObject prevEntry;
                    JavaThing entryThing1;
                    JavaObject entry = (JavaObject)entryThing;
                    do {
                        entryFields = entry.getFields(entryFields);
                        JavaThing keyThing = entryFields[f.referentFieldIdx];
                        JavaThing valueThing = entryFields[f.valueFieldIdx];
                        if (keyThing != null && keyThing instanceof JavaHeapObject && valueThing instanceof JavaHeapObject) {
                            keys[entryIdx] = (JavaHeapObject)keyThing;
                            values[entryIdx] = (JavaHeapObject)valueThing;
                            if (++entryIdx == keys.length) break block0;
                        }
                        prevEntry = entry;
                        entryThing1 = entryFields[f.nextFieldIdx];
                        if (entryThing1 == null || !(entryThing1 instanceof JavaObject)) break block6;
                    } while ((entry = (JavaObject)entryThing1) != prevEntry);
                    throw new RuntimeException("Problem in data: WeakHashMap$Entry.next points to itself?");
                }
            }
            ++n2;
        }
        return new JavaHeapObject[][]{keys, values};
    }

    static class Factory
    extends ArrayBasedCollectionDescriptor.Factory {
        private final int referentFieldIdx;
        private final int valueFieldIdx;
        private final int nextFieldIdx;

        Factory(JavaClass clazz, JavaClass[] implClasses) {
            super(clazz, true, ClassUtils.getExactFieldName("size|elementCount", clazz), ClassUtils.getExactFieldName("table|elementData", clazz), 16, implClasses, null);
            this.setMapKeyFieldName("referent");
            JavaClass entryClass = null;
            JavaClass[] javaClassArray = implClasses;
            int n = implClasses.length;
            int n2 = 0;
            while (n2 < n) {
                JavaClass implClass = javaClassArray[n2];
                if (implClass.getName().equals("java.util.WeakHashMap$Entry")) {
                    entryClass = implClass;
                    break;
                }
                ++n2;
            }
            if (entryClass == null) {
                throw new RuntimeException("Could not find class java.util.WeakHashMap$Entry");
            }
            this.referentFieldIdx = entryClass.getInstanceFieldIndex("referent");
            this.valueFieldIdx = entryClass.getInstanceFieldIndex("value");
            int localNextFieldIdx = -1;
            JavaField[] fieldDescs = entryClass.getFieldsForInstance();
            int i = fieldDescs.length - 1;
            while (i >= 0) {
                if ("next".equals(fieldDescs[i].getName())) {
                    localNextFieldIdx = i;
                    break;
                }
                --i;
            }
            int nDefinedFields = entryClass.getDefinedFields().length;
            if (localNextFieldIdx == -1 || localNextFieldIdx < fieldDescs.length - nDefinedFields) {
                throw new RuntimeException("Could not find field next in java.util.WeakHashMap$Entry");
            }
            this.nextFieldIdx = localNextFieldIdx;
        }

        private Factory(JavaClass clazz, AbstractArrayBasedCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            Factory f = (Factory)superclassFactory;
            this.referentFieldIdx = f.referentFieldIdx;
            this.valueFieldIdx = f.valueFieldIdx;
            this.nextFieldIdx = f.nextFieldIdx;
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        ArrayBasedCollectionDescriptor get(JavaObject col) {
            return new WeakHashMapDescriptor(col, this);
        }
    }
}

