/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.swt_awt;

import io.github.bric3.fireplace.swt_awt.SWT_AWTBridge;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.JApplet;
import javax.swing.JComponent;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EmbeddingComposite
extends Composite {
    public EmbeddingComposite(Composite parent) {
        this(parent, 0);
    }

    public EmbeddingComposite(Composite parent, int style) {
        super(parent, EmbeddingComposite.checkNotBorder(style) | 0x1000000 | 0x40000);
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new GridLayout(1, true));
    }

    private static int checkNotBorder(int style) {
        if ((style & 0x800) != 0) {
            throw new IllegalArgumentException("Border style is known to cause problem with the integration, apply the border to a wrapping SWT component");
        }
        return style;
    }

    public void init(Supplier<JComponent> jComponentSupplier) {
        final Frame frame = SWT_AWT.new_Frame((Composite)this);
        frame.getInputContext();
        this.addDisposeListener(e -> {
            System.out.println("embedded composite disposed");
            SWT_AWTBridge.invokeInEDTAndWait(() -> {
                try {
                    frame.removeNotify();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        });
        AtomicReference<Object> componentRef = new AtomicReference<Object>(null);
        SWT_AWTBridge.invokeInEDTAndWait(() -> {
            JComponent jComponent = (JComponent)jComponentSupplier.get();
            componentRef.set(jComponent);
            JApplet applet = new JApplet(){

                @Override
                public InputContext getInputContext() {
                    return null;
                }
            };
            applet.setFocusCycleRoot(false);
            applet.setLayout(new BorderLayout());
            applet.add((Component)jComponent, "Center");
            frame.add(applet);
            frame.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if ((e.getModifiersEx() & 0x100) != 0 && e.getKeyChar() == 'q') {
                        System.out.println("cmd+q pressed");
                        frame.dispose();
                        SWT_AWTBridge.invokeSwtAwayFromAwt(EmbeddingComposite.this.getDisplay(), () -> EmbeddingComposite.this.getDisplay().dispose());
                    }
                }
            });
        });
        Dimension dimension = SWT_AWTBridge.computeInEDT(() -> ((JComponent)componentRef.get()).getPreferredSize());
        this.setSize(dimension.width, dimension.height);
    }
}

