/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.rcp.application.p2.AddRepositoriesJob;
import org.openjdk.jmc.rcp.logging.LoggingToolkit;
import org.osgi.framework.BundleContext;

public class ApplicationPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.openjdk.jmc.rcp.application";
    private static final String VERSION_PROPERTIES = "/about.mappings";
    private static final String UNKNOWN_VERSION = "unknown";
    private static ApplicationPlugin plugin;
    public static final String VERSION;
    public static final String FULL_VERSION;
    public static final String ICON_UPDATE_SEARCH = "/icons/usearch_obj.gif";
    public static final String ICON_ERROR_MARKER = "/icons/error_marker.gif";
    public static final String ICON_INSTRUCTION_POINTER = "/icons/inst_ptr_top.gif";

    static {
        String fullVersion;
        String version;
        block5: {
            version = UNKNOWN_VERSION;
            fullVersion = UNKNOWN_VERSION;
            Properties props = new Properties();
            InputStream is = null;
            try {
                try {
                    is = ApplicationPlugin.class.getResourceAsStream(VERSION_PROPERTIES);
                    props.load(is);
                    version = props.getProperty("0");
                    fullVersion = props.getProperty("4");
                }
                catch (Exception exception) {
                    IOToolkit.closeSilently((Closeable)is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
        }
        VERSION = version;
        FULL_VERSION = fullVersion;
    }

    public ApplicationPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeDebug();
        LoggingToolkit.initializeLogging();
        new AddRepositoriesJob(context).schedule();
    }

    private void initializeDebug() {
        if (System.getProperty("osgi.debug") != null) {
            System.setProperty("org.openjdk.jmc.debug", "true");
            ApplicationPlugin.getLogger().log(Level.INFO, "JMC debug mode enabled");
        }
    }

    public static Logger getLogger() {
        return LoggingToolkit.getLogger();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(ICON_ERROR_MARKER, ApplicationPlugin.getImageDescriptor(ICON_ERROR_MARKER));
        reg.put(ICON_INSTRUCTION_POINTER, ApplicationPlugin.getImageDescriptor(ICON_INSTRUCTION_POINTER));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ApplicationPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)path).orElse(null);
    }
}

