/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.base.IHelpScopeProducer;
import org.eclipse.help.base.IScopeHandle;
import org.eclipse.help.internal.base.scope.IntersectionScope;
import org.eclipse.help.internal.base.scope.ScopeHandle;
import org.eclipse.help.internal.base.scope.UnionScope;
import org.eclipse.help.internal.base.scope.UniversalScope;

public class ScopeRegistry {
    public static final String SCOPE_XP_NAME = "org.eclipse.help.base.scope";
    public static final String ENABLEMENT_SCOPE_ID = "org.eclipse.help.enablement";
    public static final String SEARCH_SCOPE_SCOPE_ID = "org.eclipse.help.searchscope";
    public static final String SCOPE_AND = "^";
    public static final String SCOPE_OR = "|";
    private static List<IScopeHandle> scopes = null;
    private boolean initialized = false;

    private ScopeRegistry() {
    }

    public static ScopeRegistry getInstance() {
        return RegistryHolder.instance;
    }

    public AbstractHelpScope getScope(String id) {
        if (id == null) {
            return new UniversalScope();
        }
        this.readScopes();
        for (IScopeHandle handle : scopes) {
            if (!id.equals(handle.getId())) continue;
            return handle.getScope();
        }
        return null;
    }

    private synchronized void readScopes() {
        IConfigurationElement[] elements;
        if (this.initialized) {
            return;
        }
        scopes = new ArrayList<IScopeHandle>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(SCOPE_XP_NAME);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Object obj = null;
            try {
                obj = element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                ILog.of(this.getClass()).error("Create extension failed:[org.eclipse.help.base.scope].", (Throwable)e);
            }
            if (obj instanceof AbstractHelpScope) {
                String id = element.getAttribute("id");
                ScopeHandle filter = new ScopeHandle(id, (AbstractHelpScope)obj);
                scopes.add(filter);
            } else if (obj instanceof IHelpScopeProducer) {
                IScopeHandle[] dynamicScopes = ((IHelpScopeProducer)obj).getScopeHandles();
                Collections.addAll(scopes, dynamicScopes);
            }
            ++n2;
        }
        this.initialized = true;
    }

    public IScopeHandle[] getScopes() {
        this.readScopes();
        return scopes.toArray(new IScopeHandle[scopes.size()]);
    }

    public AbstractHelpScope parseScopePhrases(String[] phrases) {
        ArrayList<AbstractHelpScope> scopes = new ArrayList<AbstractHelpScope>();
        String[] stringArray = phrases;
        int n = phrases.length;
        int n2 = 0;
        while (n2 < n) {
            String phrase = stringArray[n2];
            AbstractHelpScope scope = this.parseScopePhrase(phrase);
            if (scope != null) {
                scopes.add(scope);
            }
            ++n2;
        }
        if (scopes.isEmpty()) {
            return null;
        }
        if (scopes.size() == 1) {
            return (AbstractHelpScope)scopes.get(0);
        }
        return new IntersectionScope(scopes.toArray(new AbstractHelpScope[scopes.size()]));
    }

    public AbstractHelpScope parseScopePhrase(String phrase) {
        String elem;
        if (!((String)phrase).startsWith("(") || ((String)phrase).startsWith("(")) {
            phrase = "(" + (String)phrase + ")";
        }
        Stack<TempScope> scopeStack = new Stack<TempScope>();
        ScopePhrase scopePhrase = new ScopePhrase((String)phrase);
        while ((elem = scopePhrase.getNextElement()) != null) {
            TempScope scope;
            if (elem.equals("(")) {
                scope = new TempScope();
                scope.setType(0);
                scopeStack.push(scope);
                continue;
            }
            if (elem.equals(")")) {
                scope = (TempScope)scopeStack.pop();
                if (scopeStack.isEmpty()) {
                    return scope.getScope();
                }
                TempScope parent = (TempScope)scopeStack.peek();
                parent.add(scope.getScope());
                continue;
            }
            if (elem.equals(SCOPE_AND)) {
                scope = (TempScope)scopeStack.peek();
                scope.setType(2);
                continue;
            }
            if (elem.equals(SCOPE_OR)) {
                scope = (TempScope)scopeStack.peek();
                scope.setType(1);
                continue;
            }
            scope = (TempScope)scopeStack.peek();
            AbstractHelpScope helpScope = this.getScope(elem);
            if (helpScope == null) continue;
            scope.add(helpScope);
        }
        return null;
    }

    private static class RegistryHolder {
        static final ScopeRegistry instance = new ScopeRegistry();

        private RegistryHolder() {
        }
    }

    static class ScopePhrase {
        private final String phrase;
        private int cursor;

        public ScopePhrase(String phrase) {
            this.phrase = phrase;
            this.cursor = 0;
        }

        public String getNextElement() {
            Object next = "";
            while (this.cursor < this.phrase.length()) {
                char current = this.phrase.charAt(this.cursor);
                if (current == '(') {
                    return this.format((String)next, current);
                }
                if (current == ')') {
                    return this.format((String)next, current);
                }
                if (("" + current).equals(ScopeRegistry.SCOPE_AND)) {
                    return this.format((String)next, current);
                }
                if (("" + current).equals(ScopeRegistry.SCOPE_OR)) {
                    return this.format((String)next, current);
                }
                next = (String)next + current;
                ++this.cursor;
            }
            if (((String)next).isEmpty()) {
                return null;
            }
            return next;
        }

        private String format(String next, char current) {
            if (next.isEmpty()) {
                ++this.cursor;
                return "" + current;
            }
            return next;
        }
    }

    private static class TempScope {
        public static final int SELF = 0;
        public static final int UNION = 1;
        public static final int INTERSECTION = 2;
        private final ArrayList<AbstractHelpScope> kids = new ArrayList();
        private int type;

        private TempScope() {
        }

        public void setType(int type) {
            this.type = type;
        }

        public void add(AbstractHelpScope kid) {
            this.kids.add(kid);
        }

        public AbstractHelpScope getScope() {
            switch (this.type) {
                case 1: {
                    return new UnionScope(this.kids.toArray(new AbstractHelpScope[this.kids.size()]));
                }
                case 2: {
                    return new IntersectionScope(this.kids.toArray(new AbstractHelpScope[this.kids.size()]));
                }
            }
            if (this.kids.size() >= 1) {
                return this.kids.get(0);
            }
            return null;
        }
    }
}

