/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.idesupport;

import java.io.Closeable;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.ui.common.CorePlugin;
import org.openjdk.jmc.ui.common.idesupport.Messages;
import org.openjdk.jmc.ui.common.resource.MCFile;

final class JobFileWrite
extends Job {
    private final MCFile file;
    private final InputStream stream;
    private final boolean append;
    private final String triggerMessage;

    JobFileWrite(String jobName, MCFile file, InputStream stream, boolean append, String triggerMessage) {
        super(jobName);
        this.file = file;
        this.stream = stream;
        this.append = append;
        this.triggerMessage = triggerMessage;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                this.file.writeStream(this.stream, monitor, this.append);
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not write the specified file!", e);
                Status status = new Status(4, "org.openjdk.jmc.ui.common", NLS.bind((String)("\n" + this.triggerMessage + "\n" + Messages.JobFileWrite_ERROR_FILE_WRITE_FAILED), (Object)this.file.getPath()), (Throwable)e);
                IOToolkit.closeSilently((Closeable)this.stream);
                return status;
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)this.stream);
        }
        return new Status(0, "org.openjdk.jmc.ui.common", NLS.bind((String)Messages.JobFileWrite_MESSAGE_FILE_WRITE_SUCCESS, (Object)this.file.getPath()));
    }
}

