/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JvmInternalsDataProvider {
    private static final String[] PREFIXES = new String[]{"-Xmx", "-Xms", "-Xmn", "-Xss", "-Xmaxjitcodesize"};
    private static final String[] VERBATIM = new String[]{"-verbose", "--add-exports", "--add-opens"};
    private static final String[] OPTIONS = new String[]{"-XX", "-javaagent", "-agent"};
    private static final Map<String, String> EQUIVALENT = new HashMap<String, String>();

    private static void putBiMap(String one, String two) {
        EQUIVALENT.put(one, two);
        EQUIVALENT.put(two, one);
    }

    public static Collection<ArrayList<String>> checkDuplicates(String arguments) {
        HashMap<String, String> seenFlags = new HashMap<String, String>();
        HashMap dupes = new HashMap();
        String[] argumentArray = arguments.split(" ");
        if (argumentArray.length == 1 && argumentArray[0].equals("")) {
            return dupes.values();
        }
        for (String fullArgument : argumentArray) {
            String flag;
            boolean verbatim = false;
            for (int i = 0; i < VERBATIM.length; ++i) {
                if (!fullArgument.contains(VERBATIM[i])) continue;
                verbatim = true;
                break;
            }
            if (verbatim) {
                flag = fullArgument;
            } else {
                int i;
                String[] split = fullArgument.split("[:=]", 2);
                flag = split[0];
                for (i = 0; i < OPTIONS.length; ++i) {
                    if (!OPTIONS[i].equals(split[0])) continue;
                    String flagWithOptions = split[1];
                    flag = flagWithOptions.split("[=]")[0];
                    if (!flag.startsWith("+") && !flag.startsWith("-")) break;
                    flag = flag.substring(1);
                    break;
                }
                for (i = 0; i < PREFIXES.length; ++i) {
                    flag = JvmInternalsDataProvider.scrubPrefix(flag, PREFIXES[i]);
                }
                String equivalentArgument = EQUIVALENT.get(flag);
                if (equivalentArgument != null && !seenFlags.containsKey(flag) && seenFlags.containsKey(equivalentArgument)) {
                    flag = equivalentArgument;
                }
            }
            if (seenFlags.containsKey(flag)) {
                if (!dupes.containsKey(flag)) {
                    dupes.put(flag, new ArrayList());
                    ((ArrayList)dupes.get(flag)).add((String)seenFlags.get(flag));
                }
                ((ArrayList)dupes.get(flag)).add(fullArgument);
                continue;
            }
            seenFlags.put(flag, fullArgument);
        }
        return dupes.values();
    }

    private static String scrubPrefix(String argument, String prefix) {
        return argument.startsWith(prefix) ? prefix : argument;
    }

    static {
        JvmInternalsDataProvider.putBiMap("-Xbatch", "BackgroundCompilation");
        JvmInternalsDataProvider.putBiMap("-Xmaxjitcodesize", "ReservedCodeCacheSize");
        JvmInternalsDataProvider.putBiMap("-Xmx", "MaxHeapSize");
        JvmInternalsDataProvider.putBiMap("-Xmn", "NewSize");
        JvmInternalsDataProvider.putBiMap("-Xss", "ThreadStackSize");
        JvmInternalsDataProvider.putBiMap("-Xusealtsigs", "UseAltSigs");
        JvmInternalsDataProvider.putBiMap("-cp", "classpath");
        JvmInternalsDataProvider.putBiMap("-esa", "enablesystemassertions");
        JvmInternalsDataProvider.putBiMap("-dsa", "disablesystemassertions");
        JvmInternalsDataProvider.putBiMap("-Xconcgc", "UseConcMarkSweepGC");
        JvmInternalsDataProvider.putBiMap("-Xnoconcgc", "UseConcMarkSweepGC");
        JvmInternalsDataProvider.putBiMap("-Xnoclassgc", "ClassUnloading");
        JvmInternalsDataProvider.putBiMap("-Xminf", "MinHeapFreeRatio");
        JvmInternalsDataProvider.putBiMap("-Xmaxf", "MaxHeapFreeRatio");
        JvmInternalsDataProvider.putBiMap("-Xrs", "ReduceSignalUsage");
        JvmInternalsDataProvider.putBiMap("-Dcom.sun.management", "ManagementServer");
        JvmInternalsDataProvider.putBiMap("-Xshare:dump", "DumpSharedSpaces");
        JvmInternalsDataProvider.putBiMap("-Xboundthreads", "UseBoundThreads");
        JvmInternalsDataProvider.putBiMap("AlwaysTenure", "NeverTenure");
        JvmInternalsDataProvider.putBiMap("ResizeTLE", "ResizeTLAB");
        JvmInternalsDataProvider.putBiMap("PrintTLE", "PrintTLAB");
        JvmInternalsDataProvider.putBiMap("TLESize", "TLABSize");
        JvmInternalsDataProvider.putBiMap("UseTLE", "UseTLAB");
        JvmInternalsDataProvider.putBiMap("UsePermISM", "UseISM");
        JvmInternalsDataProvider.putBiMap("G1MarkStackSize", "CMSMarkStackSize");
        JvmInternalsDataProvider.putBiMap("-Xms", "InitialHeapSize");
        JvmInternalsDataProvider.putBiMap("DisplayVMOutputToStderr", "DisplayVMOutputToStdout");
        JvmInternalsDataProvider.putBiMap("-Xverify", "BytecodeVerificationLocal");
        JvmInternalsDataProvider.putBiMap("-Xverify", "BytecodeVerificationRemote");
        JvmInternalsDataProvider.putBiMap("DefaultMaxRAMFraction", "MaxRAMFraction");
        JvmInternalsDataProvider.putBiMap("CMSMarkStackSizeMax", "MarkStackSizeMax");
        JvmInternalsDataProvider.putBiMap("ParallelMarkingThreads", "ConcGCThreads");
        JvmInternalsDataProvider.putBiMap("ParallelCMSThreads", "ConcGCThreads");
        JvmInternalsDataProvider.putBiMap("CreateMinidumpOnCrash", "CreateCoredumpOnCrash");
    }
}

