/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.impl.QuietLogHandler;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.discovery.DiscoveryIncomingMessage;
import org.jolokia.service.discovery.DiscoveryOutgoingMessage;

public final class MulticastUtil {
    private MulticastUtil() {
    }

    static MulticastSocket newMulticastSocket(InetAddress pAddress, JolokiaContext pContext) throws IOException {
        String multicastGroup = pContext.getConfig(ConfigKey.MULTICAST_GROUP, true);
        int multicastPort = Integer.parseInt(pContext.getConfig(ConfigKey.MULTICAST_PORT, true));
        InetSocketAddress socketAddress = new InetSocketAddress(multicastGroup, multicastPort);
        MulticastSocket socket = new MulticastSocket(multicastPort);
        socket.setReuseAddress(true);
        MulticastUtil.setOutgoingInterfaceForMulticastRequest(pAddress, socket);
        socket.setTimeToLive(255);
        if (MulticastUtil.joinMcGroupsOnAllNetworkInterfaces(socket, socketAddress, (LogHandler)pContext) == 0) {
            throw new IOException("Couldn't join multicast group " + String.valueOf(socketAddress) + " on any network interfaces");
        }
        return socket;
    }

    public static List<DiscoveryIncomingMessage> sendQueryAndCollectAnswers(DiscoveryOutgoingMessage pOutMsg, int pTimeout, String pMulticastGroup, int pMulticastPort) throws IOException {
        return MulticastUtil.sendQueryAndCollectAnswers(pOutMsg, pTimeout, pMulticastGroup, pMulticastPort, (LogHandler)new QuietLogHandler());
    }

    public static List<DiscoveryIncomingMessage> sendQueryAndCollectAnswers(DiscoveryOutgoingMessage pOutMsg, int pTimeout, String pMulticastGroup, int pMulticastPort, LogHandler pLogHandler) throws IOException {
        List<Future<List<DiscoveryIncomingMessage>>> futures = MulticastUtil.sendDiscoveryRequests(pOutMsg, pTimeout, pMulticastGroup, pMulticastPort, pLogHandler);
        return MulticastUtil.collectIncomingMessages(pTimeout, futures, pLogHandler);
    }

    private static List<Future<List<DiscoveryIncomingMessage>>> sendDiscoveryRequests(DiscoveryOutgoingMessage pOutMsg, int pTimeout, String pMulticastGroup, int pMulticastPort, LogHandler pLogHandler) throws UnknownHostException {
        List<InetAddress> addresses = MulticastUtil.getMulticastAddresses();
        ExecutorService executor = Executors.newFixedThreadPool(addresses.size());
        ArrayList<Future<List<DiscoveryIncomingMessage>>> futures = new ArrayList<Future<List<DiscoveryIncomingMessage>>>(addresses.size());
        for (InetAddress address : addresses) {
            DatagramPacket out = pOutMsg.createDatagramPacket(InetAddress.getByName(pMulticastGroup), pMulticastPort);
            FindAgentsCallable findAgentsCallable = new FindAgentsCallable(address, out, pTimeout, pLogHandler);
            futures.add(executor.submit(findAgentsCallable));
        }
        executor.shutdownNow();
        return futures;
    }

    private static List<InetAddress> getMulticastAddresses() throws UnknownHostException {
        List addresses = NetworkUtil.getMulticastAddresses();
        if (addresses.isEmpty()) {
            throw new UnknownHostException("Cannot find address of local host which can be used for sending discovery request");
        }
        return addresses;
    }

    private static List<DiscoveryIncomingMessage> collectIncomingMessages(int pTimeout, List<Future<List<DiscoveryIncomingMessage>>> pFutures, LogHandler pLogHandler) throws UnknownHostException {
        ArrayList<DiscoveryIncomingMessage> ret = new ArrayList<DiscoveryIncomingMessage>();
        HashSet<String> seen = new HashSet<String>();
        int nrCouldntSend = 0;
        for (Future<List<DiscoveryIncomingMessage>> future : pFutures) {
            try {
                List<DiscoveryIncomingMessage> inMsgs = future.get(pTimeout + 500, TimeUnit.MILLISECONDS);
                for (DiscoveryIncomingMessage inMsg : inMsgs) {
                    AgentDetails details = inMsg.getAgentDetails();
                    String id = details.getAgentId();
                    if (seen.contains(id)) continue;
                    ret.add(inMsg);
                    seen.add(id);
                }
            }
            catch (InterruptedException inMsgs) {
            }
            catch (ExecutionException e) {
                Throwable exp = e.getCause();
                if (exp instanceof CouldntSendDiscoveryPacketException) {
                    ++nrCouldntSend;
                    pLogHandler.debug("--> Couldnt send discovery message from " + String.valueOf(((CouldntSendDiscoveryPacketException)exp).getAddress()) + ": " + String.valueOf(exp.getCause()));
                }
                pLogHandler.debug("--> Exception during lookup: " + String.valueOf(e));
            }
            catch (TimeoutException timeoutException) {
            }
        }
        if (nrCouldntSend == pFutures.size()) {
            throw new UnknownHostException("Cannot send a single multicast recovery request on any multicast enabled interface");
        }
        return ret;
    }

    private static int joinMcGroupsOnAllNetworkInterfaces(MulticastSocket pSocket, InetSocketAddress pSocketAddress, LogHandler pLogHandler) throws IOException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        int interfacesJoined = 0;
        while (nifs.hasMoreElements()) {
            NetworkInterface n = nifs.nextElement();
            if (!NetworkUtil.isMulticastSupported((NetworkInterface)n)) continue;
            try {
                pSocket.joinGroup(pSocketAddress, n);
                ++interfacesJoined;
            }
            catch (IOException exp) {
                pLogHandler.info("Cannot join multicast group on NIF " + n.getDisplayName() + ": " + exp.getMessage());
            }
        }
        return interfacesJoined;
    }

    private static void setOutgoingInterfaceForMulticastRequest(InetAddress pAddress, MulticastSocket pSocket) throws SocketException {
        NetworkInterface nif = NetworkInterface.getByInetAddress(pAddress);
        if (nif != null) {
            pSocket.setNetworkInterface(nif);
        }
    }

    private static final class FindAgentsCallable
    implements Callable<List<DiscoveryIncomingMessage>> {
        private final InetAddress address;
        private final DatagramPacket outPacket;
        private final int timeout;
        private final LogHandler logHandler;

        private FindAgentsCallable(InetAddress pAddress, DatagramPacket pOutPacket, int pTimeout, LogHandler pLogHandler) {
            this.address = pAddress;
            this.outPacket = pOutPacket;
            this.timeout = pTimeout;
            this.logHandler = pLogHandler;
        }

        @Override
        public List<DiscoveryIncomingMessage> call() throws IOException {
            DatagramSocket socket;
            try (DatagramSocket datagramSocket = socket = new DatagramSocket(0, this.address);){
                ArrayList<DiscoveryIncomingMessage> ret = new ArrayList<DiscoveryIncomingMessage>();
                try {
                    socket.setSoTimeout(this.timeout);
                    this.logHandler.debug(String.valueOf(this.address) + "--> Sending");
                    socket.send(this.outPacket);
                }
                catch (IOException exp) {
                    throw new CouldntSendDiscoveryPacketException(this.address, "Can't send discovery UDP packet from " + String.valueOf(this.address) + ": " + exp.getMessage(), exp);
                }
                try {
                    while (true) {
                        byte[] buf = new byte[8972];
                        DatagramPacket in = new DatagramPacket(buf, buf.length);
                        socket.receive(in);
                        this.logHandler.debug(String.valueOf(this.address) + "--> Received answer from " + String.valueOf(in.getAddress()));
                        this.addIncomingMessage(ret, in);
                    }
                }
                catch (SocketTimeoutException exp) {
                    this.logHandler.debug(String.valueOf(this.address) + "--> Timeout");
                }
                catch (IOException exp) {
                    throw new IOException("Cannot receive broadcast answer on " + String.valueOf(this.address) + ": " + exp.getMessage(), exp);
                }
                ArrayList<DiscoveryIncomingMessage> arrayList = ret;
                return arrayList;
            }
        }

        private void addIncomingMessage(List<DiscoveryIncomingMessage> ret, DatagramPacket in) {
            try {
                DiscoveryIncomingMessage inMsg = new DiscoveryIncomingMessage(in);
                if (!inMsg.isQuery()) {
                    ret.add(inMsg);
                }
            }
            catch (Exception exp) {
                this.logHandler.debug("Invalid incoming package from " + String.valueOf(in.getAddress()) + "  --> " + String.valueOf(exp) + ". Ignoring");
            }
        }
    }

    private static class CouldntSendDiscoveryPacketException
    extends IOException {
        private final InetAddress address;

        public CouldntSendDiscoveryPacketException(InetAddress pAddress, String pMessage, IOException pNested) {
            super(pMessage, pNested);
            this.address = pAddress;
        }

        public InetAddress getAddress() {
            return this.address;
        }
    }
}

