/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.editor.sections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;

public class GlobalConfigSection
extends MCSectionPart {
    private static final String SECTION_TITLE = "Global Configurations";
    private static final String HEADER_OPTION = "Option";
    private static final String HEADER_VALUE = "Value";
    private static final String ALLOW_TO_STRING = "Allow toString()";
    private static final String ALLOW_CONVERTER = "Allow converters";
    private static final String CLASS_PREFIX = "Class prefix";
    private static final String NO_CONFIG_APPLIED = "No configuration applied";
    private final Composite stack;
    private final StackLayout stackLayout;
    private final Composite message;
    private final TableViewer viewer;

    public GlobalConfigSection(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, 256);
        this.getSection().setText(SECTION_TITLE);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        this.stack = toolkit.createComposite(body);
        this.stack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.stack.setLayout((Layout)this.stackLayout);
        this.message = toolkit.createComposite(this.stack);
        this.message.setLayout((Layout)new GridLayout(1, false));
        toolkit.createLabel(this.message, NO_CONFIG_APPLIED).setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.viewer = this.createViewer(this.stack, toolkit);
        this.viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)true));
        this.stackLayout.topControl = this.message;
    }

    private TableViewer createViewer(Composite parent, FormToolkit formToolkit) {
        Table table = formToolkit.createTable(parent, 68096);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new ConfigContentProvider());
        ArrayList<IColumn> columns = new ArrayList<IColumn>(2);
        columns.add(new ColumnBuilder(HEADER_OPTION, HEADER_OPTION, new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)((Map.Entry)element).getKey();
            }
        }).build());
        columns.add(new ColumnBuilder(HEADER_VALUE, HEADER_VALUE, new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)((Map.Entry)element).getValue();
            }
        }).build());
        ColumnManager.build((TableViewer)viewer, columns, null);
        return viewer;
    }

    public void setInput(IPreset preset) {
        this.viewer.setInput((Object)preset);
        this.stackLayout.topControl = preset == null ? this.message : this.viewer.getControl();
        this.stack.layout();
    }

    private static class ConfigContentProvider
    extends AbstractStructuredContentProvider {
        private ConfigContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (!(inputElement instanceof IPreset)) {
                throw new IllegalArgumentException("input element must be an IPreset");
            }
            IPreset preset = (IPreset)inputElement;
            HashMap<String, String> entries = new HashMap<String, String>(3);
            entries.put(GlobalConfigSection.ALLOW_TO_STRING, String.valueOf(preset.getAllowToString()));
            entries.put(GlobalConfigSection.ALLOW_CONVERTER, String.valueOf(preset.getAllowConverter()));
            entries.put(GlobalConfigSection.CLASS_PREFIX, preset.getClassPrefix());
            return entries.entrySet().toArray(new Map.Entry[0]);
        }
    }
}

