/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openjdk.jmc.console.agent.manager.model.Field;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IField;
import org.openjdk.jmc.console.agent.manager.model.IMethodParameter;
import org.openjdk.jmc.console.agent.manager.model.IMethodReturnValue;
import org.openjdk.jmc.console.agent.manager.model.MethodParameter;
import org.openjdk.jmc.console.agent.manager.model.MethodReturnValue;
import org.openjdk.jmc.console.agent.manager.model.Preset;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Event
implements IEvent {
    private static final String DEFAULT_STRING_FIELD = "";
    private static final boolean DEFAULT_BOOLEAN_FIELD = false;
    private static final Object DEFAULT_OBJECT_FIELD = null;
    private static final String DEFAULT_EVENT_ID = "event.id";
    private static final String DEFAULT_EVENT_NAME = "New Custom Event";
    private static final String DEFAULT_EVENT_CLAZZ = "com.company.project.MyClass";
    private static final String DEFAULT_METHOD_NAME = "myMethod";
    private static final String DEFAULT_METHOD_DESCRIPTOR = "()V";
    private static final String CLAZZ_REGEX = "([a-zA-Z_$][a-zA-Z0-9_$]*\\.)*([a-zA-Z_$][a-zA-Z0-9_$]*)";
    private static final String PATH_REGEX = "([^/]+/)*([^/]*)";
    private static final String METHOD_NAME_REGEX = "[a-zA-Z_$][a-zA-Z0-9_$]*";
    private static final String METHOD_DESCRIPTOR_REGEX = "\\((\\[*([BCDFIJSZ]|L([a-zA-Z_$][a-zA-Z0-9_$]*/)*[a-zA-Z_$][a-zA-Z0-9_$]*;))*\\)(V|\\[*([BCDFIJSZ]|L([a-zA-Z_$][a-zA-Z0-9_$]*/)*[a-zA-Z_$][a-zA-Z0-9_$]*;))";
    private static final Pattern NAME_WITH_COUNT_PATTERN = Pattern.compile("^(.*)\\s*\\((\\d+)\\)$");
    private static final Pattern COUNT_SUFFIX_PATTERN = Pattern.compile("^\\s*\\((\\d+)\\)$");
    private static final String XML_TAG_EVENT = "event";
    private static final String XML_TAG_NAME = "label";
    private static final String XML_TAG_DESCRIPTION = "description";
    private static final String XML_TAG_CLASS = "class";
    private static final String XML_TAG_PATH = "path";
    private static final String XML_TAG_STACK_TRACE = "stacktrace";
    private static final String XML_TAG_RETHROW = "rethrow";
    private static final String XML_TAG_LOCATION = "location";
    private static final String XML_TAG_METHOD = "method";
    private static final String XML_TAG_DESCRIPTOR = "descriptor";
    private static final String XML_TAG_PARAMETERS = "parameters";
    private static final String XML_TAG_PARAMETER = "parameter";
    private static final String XML_TAG_FIELDS = "fields";
    private static final String XML_TAG_FIELD = "field";
    private static final String XML_TAG_RETURN_VALUE = "returnvalue";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_TAG_METHOD_NAME = "name";
    private final Preset preset;
    private final List<IMethodParameter> parameters = new ArrayList<IMethodParameter>();
    private final List<IField> fields = new ArrayList<IField>();
    private String id;
    private String name;
    private String clazz;
    private String description;
    private String path;
    private boolean recordStackTrace;
    private boolean useRethrow;
    private IEvent.Location location;
    private String methodName;
    private String methodDescriptor;
    private IMethodReturnValue returnValue;

    Event(Preset preset) {
        this.preset = preset;
        this.id = DEFAULT_EVENT_ID;
        this.name = DEFAULT_EVENT_NAME;
        this.clazz = DEFAULT_EVENT_CLAZZ;
        this.description = DEFAULT_STRING_FIELD;
        this.path = DEFAULT_STRING_FIELD;
        this.recordStackTrace = false;
        this.useRethrow = false;
        this.methodName = DEFAULT_METHOD_NAME;
        this.methodDescriptor = DEFAULT_METHOD_DESCRIPTOR;
        this.location = (IEvent.Location)((Object)DEFAULT_OBJECT_FIELD);
    }

    Event(Preset preset, Element element) {
        this(preset);
        Element fieldsElement;
        Element returnValueElement;
        Element locationElement;
        Element rethrowElement;
        Element stackTraceElement;
        Element pathElement;
        this.id = element.getAttribute(XML_ATTRIBUTE_ID);
        this.name = Event.getFirstDirectChildElementByTagName(element, XML_TAG_NAME).getTextContent();
        this.clazz = Event.getFirstDirectChildElementByTagName(element, XML_TAG_CLASS).getTextContent();
        Element descriptionElement = Event.getFirstDirectChildElementByTagName(element, XML_TAG_DESCRIPTION);
        if (descriptionElement != null) {
            this.description = descriptionElement.getTextContent();
        }
        if ((pathElement = Event.getFirstDirectChildElementByTagName(element, XML_TAG_PATH)) != null) {
            this.path = pathElement.getTextContent();
        }
        if ((stackTraceElement = Event.getFirstDirectChildElementByTagName(element, XML_TAG_STACK_TRACE)) != null) {
            this.recordStackTrace = Boolean.parseBoolean(stackTraceElement.getTextContent());
        }
        if ((rethrowElement = Event.getFirstDirectChildElementByTagName(element, XML_TAG_RETHROW)) != null) {
            this.useRethrow = Boolean.parseBoolean(rethrowElement.getTextContent());
        }
        if ((locationElement = Event.getFirstDirectChildElementByTagName(element, XML_TAG_LOCATION)) != null) {
            this.location = IEvent.Location.valueOf(locationElement.getTextContent().toUpperCase(Locale.ENGLISH));
        }
        Element methodElement = Event.getFirstDirectChildElementByTagName(element, XML_TAG_METHOD);
        this.methodName = Event.getFirstDirectChildElementByTagName(methodElement, XML_TAG_METHOD_NAME).getTextContent();
        this.methodDescriptor = Event.getFirstDirectChildElementByTagName(methodElement, XML_TAG_DESCRIPTOR).getTextContent();
        Element parametersElement = Event.getFirstDirectChildElementByTagName(methodElement, XML_TAG_PARAMETERS);
        if (parametersElement != null) {
            NodeList parameterNodes = parametersElement.getElementsByTagName(XML_TAG_PARAMETER);
            int i = 0;
            while (i < parameterNodes.getLength()) {
                this.parameters.add(this.createMethodParameter((Element)parameterNodes.item(i)));
                ++i;
            }
        }
        if ((returnValueElement = Event.getFirstDirectChildElementByTagName(methodElement, XML_TAG_RETURN_VALUE)) != null) {
            this.returnValue = this.createMethodReturnValue(returnValueElement);
        }
        if ((fieldsElement = Event.getFirstDirectChildElementByTagName(element, XML_TAG_FIELDS)) != null) {
            NodeList fieldNodes = fieldsElement.getElementsByTagName(XML_TAG_FIELD);
            int i = 0;
            while (i < fieldNodes.getLength()) {
                this.fields.add(this.createField((Element)fieldNodes.item(i)));
                ++i;
            }
        }
    }

    private Element buildMethodElement(Document document) {
        Element methodElement = document.createElement(XML_TAG_METHOD);
        Element methodNameElement = document.createElement(XML_TAG_METHOD_NAME);
        methodNameElement.setTextContent(this.methodName);
        methodElement.appendChild(methodNameElement);
        Element methodDescriptorElement = document.createElement(XML_TAG_DESCRIPTOR);
        methodDescriptorElement.setTextContent(this.methodDescriptor);
        methodElement.appendChild(methodDescriptorElement);
        if (!this.parameters.isEmpty()) {
            Element methodParametersElement = document.createElement(XML_TAG_PARAMETERS);
            for (IMethodParameter methodParameter : this.parameters) {
                methodParametersElement.appendChild(methodParameter.buildElement(document));
            }
            methodElement.appendChild(methodParametersElement);
        }
        if (this.returnValue != null) {
            methodElement.appendChild(this.returnValue.buildElement(document));
        }
        return methodElement;
    }

    @Override
    public Element buildElement(Document document) {
        Element element = document.createElement(XML_TAG_EVENT);
        element.setAttribute(XML_ATTRIBUTE_ID, this.id);
        Element nameElement = document.createElement(XML_TAG_NAME);
        nameElement.setTextContent(this.name);
        element.appendChild(nameElement);
        if (this.description != null && !this.description.isEmpty()) {
            Element descriptionElement = document.createElement(XML_TAG_DESCRIPTION);
            descriptionElement.setTextContent(this.description);
            element.appendChild(descriptionElement);
        }
        Element classElement = document.createElement(XML_TAG_CLASS);
        classElement.setTextContent(this.clazz);
        element.appendChild(classElement);
        if (this.path != null && !this.path.isEmpty()) {
            Element pathElement = document.createElement(XML_TAG_PATH);
            pathElement.setTextContent(this.path);
            element.appendChild(pathElement);
        }
        Element stackTraceElement = document.createElement(XML_TAG_STACK_TRACE);
        stackTraceElement.setTextContent(String.valueOf(this.recordStackTrace));
        element.appendChild(stackTraceElement);
        Element rethrowElement = document.createElement(XML_TAG_RETHROW);
        rethrowElement.setTextContent(String.valueOf(this.useRethrow));
        element.appendChild(rethrowElement);
        if (this.location != null) {
            Element locationElement = document.createElement(XML_TAG_LOCATION);
            locationElement.setTextContent(this.location.toString());
            element.appendChild(locationElement);
        }
        element.appendChild(this.buildMethodElement(document));
        if (!this.fields.isEmpty()) {
            Element fieldsElement = document.createElement(XML_TAG_FIELDS);
            for (IField field : this.fields) {
                fieldsElement.appendChild(field.buildElement(document));
            }
            element.appendChild(fieldsElement);
        }
        return element;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException(Messages.Event_ERROR_ID_CANNOT_BE_EMPTY_OR_NULL);
        }
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(Messages.Event_ERROR_NAME_CANNOT_BE_EMPTY_OR_NULL);
        }
        this.name = name;
    }

    @Override
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(String clazz) {
        if (clazz == null || clazz.isEmpty()) {
            throw new IllegalArgumentException(Messages.Event_ERROR_CLASS_CANNOT_BE_EMPTY_OR_NULL);
        }
        if (!(clazz = clazz.trim()).matches(CLAZZ_REGEX)) {
            throw new IllegalArgumentException(Messages.Event_ERROR_CLASS_HAS_INCORRECT_SYNTAX);
        }
        this.clazz = clazz;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        if (path != null && !(path = path.trim()).matches(PATH_REGEX)) {
            throw new IllegalArgumentException(Messages.Event_ERROR_PATH_HAS_INCORRECT_SYNTAX);
        }
        this.path = path;
    }

    @Override
    public boolean getStackTrace() {
        return this.recordStackTrace;
    }

    @Override
    public void setStackTrace(boolean enabled) {
        this.recordStackTrace = enabled;
    }

    @Override
    public boolean getRethrow() {
        return this.useRethrow;
    }

    @Override
    public void setRethrow(boolean enabled) {
        this.useRethrow = enabled;
    }

    @Override
    public IEvent.Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(IEvent.Location location) {
        this.location = location;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public void setMethodName(String methodName) {
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException(Messages.Event_ERROR_METHOD_NAME_CANNOT_BE_EMPTY_OR_NULL);
        }
        if (!(methodName = methodName.trim()).matches(METHOD_NAME_REGEX)) {
            throw new IllegalArgumentException(Messages.Event_ERROR_METHOD_NAME_HAS_INCORRECT_SYNTAX);
        }
        this.methodName = methodName;
    }

    @Override
    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @Override
    public void setMethodDescriptor(String methodDescriptor) {
        if (methodDescriptor == null || methodDescriptor.isEmpty()) {
            throw new IllegalArgumentException(Messages.Event_ERROR_METHOD_DESCRIPTOR_CANNOT_BE_EMPTY_OR_NULL);
        }
        if (!(methodDescriptor = methodDescriptor.trim()).matches(METHOD_DESCRIPTOR_REGEX)) {
            throw new IllegalArgumentException(Messages.Event_ERROR_METHOD_DESCRIPTOR_HAS_INCORRECT_SYNTAX);
        }
        this.methodDescriptor = methodDescriptor;
    }

    @Override
    public IMethodParameter[] getMethodParameters() {
        return this.parameters.toArray(new IMethodParameter[0]);
    }

    @Override
    public void addMethodParameter(IMethodParameter methodParameter) {
        if (methodParameter == null) {
            throw new IllegalArgumentException(Messages.Event_ERROR_METHOD_PARAMETER_CANNOT_BE_NULL);
        }
        if (this.containsIndex(methodParameter.getIndex())) {
            throw new IllegalArgumentException(Messages.Event_ERROR_INDEX_MUST_BE_UNIQUE);
        }
        this.parameters.add(methodParameter);
    }

    @Override
    public void removeMethodParameter(IMethodParameter methodParameter) {
        this.parameters.remove(methodParameter);
    }

    @Override
    public boolean containsMethodParameter(IMethodParameter methodParameter) {
        return this.parameters.contains(methodParameter);
    }

    @Override
    public void setMethodReturnValue(IMethodReturnValue methodReturnValue) {
        this.returnValue = methodReturnValue;
    }

    @Override
    public IMethodReturnValue getMethodReturnValue() {
        return this.returnValue;
    }

    @Override
    public IField[] getFields() {
        return this.fields.toArray(new IField[0]);
    }

    @Override
    public void addField(IField field) {
        if (field == null) {
            throw new IllegalArgumentException(Messages.Event_ERROR_FIELD_CANNOT_BE_NULL);
        }
        this.fields.add(field);
    }

    @Override
    public void removeField(IField field) {
        this.fields.remove(field);
    }

    @Override
    public boolean containsField(IField field) {
        return this.fields.contains(field);
    }

    @Override
    public Event createWorkingCopy() {
        Event copy = new Event(this.preset);
        copy.id = this.id;
        copy.name = this.name;
        copy.clazz = this.clazz;
        copy.description = this.description;
        copy.path = this.path;
        copy.recordStackTrace = this.recordStackTrace;
        copy.useRethrow = this.useRethrow;
        copy.methodName = this.methodName;
        copy.methodDescriptor = this.methodDescriptor;
        copy.location = this.location;
        if (this.returnValue != null) {
            copy.returnValue = this.returnValue.createWorkingCopy();
        }
        copy.parameters.addAll(this.parameters.stream().map(IMethodParameter::createWorkingCopy).collect(Collectors.toList()));
        copy.fields.addAll(this.fields.stream().map(IField::createWorkingCopy).collect(Collectors.toList()));
        return copy;
    }

    @Override
    public IEvent createDuplicate() {
        Event duplicate = this.createWorkingCopy();
        duplicate.id = this.preset.nextUniqueEventId(this.id);
        duplicate.name = this.preset.nextUniqueEventName(this.name);
        return duplicate;
    }

    @Override
    public int nextUniqueParameterIndex() {
        List sorted = this.parameters.stream().sorted(Comparator.comparingInt(IMethodParameter::getIndex)).collect(Collectors.toList());
        int index = 0;
        if (sorted.isEmpty()) {
            return index;
        }
        for (IMethodParameter parameter : sorted) {
            if (parameter.getIndex() > index) {
                return index;
            }
            index = parameter.getIndex() + 1;
        }
        return index;
    }

    @Override
    public String nextUniqueParameterName(String originalName) {
        String baseName = originalName = originalName.trim();
        long proposedCount = -1L;
        Matcher matcher = NAME_WITH_COUNT_PATTERN.matcher(originalName);
        if (matcher.matches()) {
            try {
                long count = Long.parseLong(matcher.group(2));
                baseName = matcher.group(1).trim();
                proposedCount = count;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int baseLen = baseName.length();
        for (IMethodParameter parameter : this.parameters) {
            String tempName = parameter.getName().trim();
            if (!tempName.startsWith(baseName)) continue;
            if (tempName.equals(baseName) && proposedCount < 1L) {
                proposedCount = 1L;
                continue;
            }
            Matcher tempMatch = COUNT_SUFFIX_PATTERN.matcher(tempName.substring(baseLen));
            if (!tempMatch.matches()) continue;
            try {
                long count = Long.parseLong(tempMatch.group(1));
                if (count >= Long.MAX_VALUE) continue;
                proposedCount = Math.max(proposedCount, count + 1L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (proposedCount == -1L) {
            return baseName;
        }
        return baseName + " (" + proposedCount + ")";
    }

    @Override
    public String nextUniqueFieldName(String originalName) {
        String baseName = originalName = originalName.trim();
        long proposedCount = -1L;
        Matcher matcher = NAME_WITH_COUNT_PATTERN.matcher(originalName);
        if (matcher.matches()) {
            try {
                long count = Long.parseLong(matcher.group(2));
                baseName = matcher.group(1).trim();
                proposedCount = count;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int baseLen = baseName.length();
        for (IField field : this.fields) {
            String tempName = field.getName().trim();
            if (!tempName.startsWith(baseName)) continue;
            if (tempName.equals(baseName) && proposedCount < 1L) {
                proposedCount = 1L;
                continue;
            }
            Matcher tempMatch = COUNT_SUFFIX_PATTERN.matcher(tempName.substring(baseLen));
            if (!tempMatch.matches()) continue;
            try {
                long count = Long.parseLong(tempMatch.group(1));
                if (count >= Long.MAX_VALUE) continue;
                proposedCount = Math.max(proposedCount, count + 1L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (proposedCount == -1L) {
            return baseName;
        }
        return baseName + " (" + proposedCount + ")";
    }

    @Override
    public MethodReturnValue createMethodReturnValue() {
        return new MethodReturnValue(this);
    }

    public MethodReturnValue createMethodReturnValue(Element element) {
        return new MethodReturnValue(this, element);
    }

    @Override
    public MethodParameter createMethodParameter() {
        MethodParameter parameter = new MethodParameter(this);
        parameter.setName(this.nextUniqueParameterName(parameter.getName()));
        parameter.setIndex(this.nextUniqueParameterIndex());
        return parameter;
    }

    private MethodParameter createMethodParameter(Element element) {
        return new MethodParameter(this, element);
    }

    @Override
    public void updateMethodParameter(IMethodParameter original, IMethodParameter workingCopy) {
        if (this.parameters.remove(original)) {
            this.parameters.add(workingCopy);
        }
    }

    @Override
    public Field createField() {
        Field field = new Field(this);
        field.setName(this.nextUniqueFieldName(field.getName()));
        return field;
    }

    private Field createField(Element element) {
        return new Field(this, element);
    }

    @Override
    public void updateField(IField original, IField workingCopy) {
        if (this.fields.remove(original)) {
            this.fields.add(workingCopy);
        }
    }

    private boolean containsIndex(int index) {
        for (IMethodParameter param : this.parameters) {
            if (param.getIndex() != index) continue;
            return true;
        }
        return false;
    }

    private static Element getFirstDirectChildElementByTagName(Element parent, String name) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && child.getNodeName().equals(name)) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }
}

