/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.util.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.openjdk.jmc.common.tree.IParent;
import org.openjdk.jmc.rjmx.common.services.IAttributeInfo;
import org.openjdk.jmc.rjmx.common.util.internal.SimpleAttributeInfo;
import org.openjdk.jmc.rjmx.services.IAttribute;
import org.openjdk.jmc.rjmx.services.IAttributeChild;
import org.openjdk.jmc.rjmx.services.IIndexedAttributeChild;
import org.openjdk.jmc.rjmx.services.IKeyedAttributeChild;
import org.openjdk.jmc.rjmx.services.IReadOnlyAttribute;
import org.openjdk.jmc.rjmx.util.internal.PartitionedList;

public abstract class AbstractReadOnlyAttribute
implements IReadOnlyAttribute,
IParent<Object> {
    private final IAttributeInfo info;

    public AbstractReadOnlyAttribute(IAttributeInfo info) {
        this.info = info;
    }

    public boolean hasChildren() {
        Object value = this.getValue();
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        if (value instanceof CompositeData) {
            return !((CompositeData)value).getCompositeType().keySet().isEmpty();
        }
        if (value instanceof TabularData) {
            return !((TabularData)value).values().isEmpty();
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        if (value instanceof IParent) {
            return ((IParent)value).hasChildren();
        }
        return false;
    }

    public Collection<?> getChildren() {
        Object value = this.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.getClass().isArray()) {
            return this.getChildren(Array.getLength(value), value.getClass().getComponentType().getName());
        }
        if (value instanceof CompositeData) {
            return this.getChildren((CompositeData)value);
        }
        if (value instanceof TabularData) {
            return this.getChildren(((TabularData)value).values());
        }
        if (value instanceof Collection) {
            return this.getChildren((Collection)value);
        }
        if (value instanceof Map) {
            return this.getChildren((Map)value);
        }
        if (value instanceof IParent) {
            return ((IParent)value).getChildren();
        }
        return Collections.emptyList();
    }

    private List<?> getChildren(int arrayLength, String arrayComponentType) {
        ArrayList<ReadOnlyArrayAttributeChild> children = new ArrayList<ReadOnlyArrayAttributeChild>(arrayLength);
        int i = 0;
        while (i < arrayLength) {
            children.add(this.createArrayAttributeChild(arrayComponentType, i));
            ++i;
        }
        return PartitionedList.create(children);
    }

    private ReadOnlyArrayAttributeChild createArrayAttributeChild(String arrayComponentType, int i) {
        Object element;
        Object value = this.getValue();
        if (value != null && !value.getClass().getComponentType().isPrimitive() && (element = Array.get(value, i)) != null) {
            arrayComponentType = element.getClass().getName();
        }
        if (this instanceof IAttribute) {
            return new ArrayAttributeChild(this, arrayComponentType, i);
        }
        return new ReadOnlyArrayAttributeChild(this, arrayComponentType, i);
    }

    private List<IReadOnlyAttribute> getChildren(CompositeData data) {
        CompositeType type = data.getCompositeType();
        ArrayList<IReadOnlyAttribute> children = new ArrayList<IReadOnlyAttribute>(type.keySet().size());
        for (String childName : type.keySet()) {
            children.add(this.createCompositeDataChild(childName, type.getType(childName).getClassName()));
        }
        return children;
    }

    private List<IReadOnlyAttribute> getChildren(Map<?, ?> map) {
        ArrayList<IReadOnlyAttribute> children = new ArrayList<IReadOnlyAttribute>(map.keySet().size());
        for (Object childName : map.keySet()) {
            children.add(new MapAttributeChild((IReadOnlyAttribute)this, childName));
        }
        return children;
    }

    private List<?> getChildren(Collection<?> data) {
        if (data instanceof List) {
            return this.getChildren((List)data);
        }
        int i = 0;
        ArrayList<CollectionAttributeChild> children = new ArrayList<CollectionAttributeChild>();
        for (Object v : data) {
            children.add(new CollectionAttributeChild(this, v, i++));
        }
        return PartitionedList.create(children);
    }

    private List<?> getChildren(List<?> list) {
        ArrayList<ListAttributeChild> children = new ArrayList<ListAttributeChild>();
        int i = 0;
        while (i < list.size()) {
            children.add(new ListAttributeChild((IReadOnlyAttribute)this, i));
            ++i;
        }
        return PartitionedList.create(children);
    }

    private IReadOnlyAttribute createCompositeDataChild(String name, String type) {
        return new AbstractReadOnlyAttribute((IAttributeInfo)new SimpleAttributeInfo(name, type)){

            @Override
            public Object getValue() {
                return ((CompositeData)AbstractReadOnlyAttribute.this.getValue()).get(this.getInfo().getName());
            }
        };
    }

    @Override
    public IAttributeInfo getInfo() {
        return this.info;
    }

    public int hashCode() {
        return this.getInfo().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IReadOnlyAttribute)) {
            return false;
        }
        IReadOnlyAttribute other = (IReadOnlyAttribute)obj;
        return other.getInfo().equals(this.getInfo()) && this.equalValues(this.getValue(), other.getValue());
    }

    private boolean equalValues(Object thisValue, Object thatValue) {
        if (thisValue == null) {
            return thatValue == null;
        }
        return thisValue.equals(thatValue);
    }

    private static abstract class AbstractReadOnlyAttributeChild
    extends AbstractReadOnlyAttribute
    implements IAttributeChild {
        private final IReadOnlyAttribute parent;

        public AbstractReadOnlyAttributeChild(IReadOnlyAttribute parent, IAttributeInfo info) {
            super(info);
            this.parent = parent;
        }

        public IReadOnlyAttribute getParent() {
            return this.parent;
        }
    }

    private static class ArrayAttributeChild
    extends ReadOnlyArrayAttributeChild
    implements IAttribute {
        private Object cachedValue = this.lookupValue();

        ArrayAttributeChild(IReadOnlyAttribute parent, String typeName, int index) {
            super(parent, typeName, index);
        }

        private Object lookupValue() {
            return Array.get(this.getParent().getValue(), this.getIndex());
        }

        @Override
        public void setValue(Object value) {
            this.cachedValue = value;
            Object array = this.getParent().getValue();
            Array.set(array, this.getIndex(), value);
            ((IAttribute)this.getParent()).setValue(array);
        }

        @Override
        public Object getValue() {
            return this.cachedValue;
        }
    }

    private static class CollectionAttributeChild
    extends AbstractReadOnlyAttributeChild
    implements Comparable<CollectionAttributeChild> {
        private final Object value;
        private final int index;

        public CollectionAttributeChild(IReadOnlyAttribute parent, Object value, int index) {
            super(parent, (IAttributeInfo)new SimpleAttributeInfo("[" + index + "]", ""));
            this.value = value;
            this.index = index;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int compareTo(CollectionAttributeChild o) {
            return this.index - o.index;
        }
    }

    private static class ListAttributeChild
    extends AbstractReadOnlyAttributeChild
    implements Comparable<ListAttributeChild>,
    IIndexedAttributeChild {
        private final int index;

        ListAttributeChild(IReadOnlyAttribute parent, int index) {
            super(parent, (IAttributeInfo)new SimpleAttributeInfo("[" + index + "]", ""));
            this.index = index;
        }

        @Override
        public Object getValue() {
            return ((List)this.getParent().getValue()).get(this.index);
        }

        @Override
        public int compareTo(ListAttributeChild o) {
            return this.index - o.index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    private static class MapAttributeChild
    extends AbstractReadOnlyAttributeChild
    implements IKeyedAttributeChild {
        private final Object key;

        public MapAttributeChild(IReadOnlyAttribute parent, Object key) {
            super(parent, (IAttributeInfo)new SimpleAttributeInfo(key.toString(), ""));
            this.key = key;
        }

        @Override
        public Object getValue() {
            return ((Map)this.getParent().getValue()).get(this.key);
        }

        @Override
        public String getKey() {
            return this.getInfo().getName();
        }
    }

    private static class ReadOnlyArrayAttributeChild
    extends AbstractReadOnlyAttributeChild
    implements Comparable<ReadOnlyArrayAttributeChild>,
    IIndexedAttributeChild {
        private final int index;

        ReadOnlyArrayAttributeChild(IReadOnlyAttribute parent, String typeName, int index) {
            super(parent, (IAttributeInfo)new SimpleAttributeInfo("[" + index + "]", typeName));
            this.index = index;
        }

        @Override
        public Object getValue() {
            return Array.get(this.getParent().getValue(), this.index);
        }

        @Override
        public int compareTo(ReadOnlyArrayAttributeChild o) {
            return this.index - o.index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }
}

