/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.api;

import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;

public abstract class AbstractJolokiaService<T extends JolokiaService<?>>
implements JolokiaService<T> {
    private final Class<T> type;
    private final int order;
    private JolokiaContext jolokiaContext;

    protected AbstractJolokiaService(Class<T> pType, int pOrderId) {
        this.type = pType;
        this.order = pOrderId;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void destroy() throws Exception {
        this.jolokiaContext = null;
    }

    @Override
    public void init(JolokiaContext pJolokiaContext) {
        this.jolokiaContext = pJolokiaContext;
    }

    @Override
    public int compareTo(T pOtherService) {
        int ret = this.getOrder() - pOtherService.getOrder();
        return ret != 0 ? ret : (this.equals(pOtherService) ? 0 : this.hashCode() - pOtherService.hashCode());
    }

    protected ObjectName registerJolokiaMBean(String pName, Object pMBean) {
        String objectNameS = this.getMBeanNameWithAgentId(pName);
        try {
            return this.jolokiaContext.registerMBean(pMBean, objectNameS);
        }
        catch (JMException e) {
            this.jolokiaContext.error("Cannot register MBean " + objectNameS + ": " + String.valueOf(e), e);
            return null;
        }
    }

    protected void unregisterJolokiaMBean(ObjectName oName) {
        if (this.jolokiaContext != null && oName != null) {
            try {
                this.jolokiaContext.unregisterMBean(oName);
            }
            catch (MBeanRegistrationException e) {
                this.jolokiaContext.error("Cannot unregister MBean " + String.valueOf(oName) + ": " + String.valueOf(e), e);
            }
        }
    }

    protected JolokiaContext getJolokiaContext() {
        return this.jolokiaContext;
    }

    private String getMBeanNameWithAgentId(String pName) {
        AgentDetails details = this.jolokiaContext.getAgentDetails();
        String agentId = details.getAgentId();
        return pName + ",agent=" + agentId;
    }
}

