/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.impl;

import java.util.Set;
import java.util.SortedSet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.service.impl.JolokiaServiceManagerImpl;
import org.jolokia.server.core.util.DebugStore;
import org.jolokia.server.core.util.HttpMethod;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;

public class JolokiaContextImpl
implements JolokiaContext {
    private final JolokiaServiceManagerImpl serviceManager;
    private DebugStore debugStore;

    JolokiaContextImpl(JolokiaServiceManagerImpl pServiceManager) {
        this.serviceManager = pServiceManager;
    }

    public void setDebugStore(DebugStore debugStore) {
        this.debugStore = debugStore;
    }

    @Override
    public ObjectName registerMBean(Object pMBean, String ... pOptionalName) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        return this.serviceManager.registerMBean(pMBean, pOptionalName);
    }

    @Override
    public void unregisterMBean(ObjectName pObjectName) throws MBeanRegistrationException {
        this.serviceManager.unregisterMBean(pObjectName);
    }

    @Override
    public MBeanServerAccess getMBeanServerAccess() {
        return this.serviceManager.getMBeanServerAccess();
    }

    @Override
    public AgentDetails getAgentDetails() {
        return this.serviceManager.getAgentDetails();
    }

    @Override
    public String getConfig(ConfigKey pOption) {
        return this.getConfiguration().getConfig(pOption);
    }

    @Override
    public String getConfig(ConfigKey pOption, boolean checkSysOrEnv) {
        return this.getConfiguration().getConfig(pOption, checkSysOrEnv);
    }

    @Override
    public Set<ConfigKey> getConfigKeys() {
        return this.getConfiguration().getConfigKeys();
    }

    @Override
    public <T extends JolokiaService<?>> SortedSet<T> getServices(Class<T> pType) {
        return this.serviceManager.getServices(pType);
    }

    @Override
    public <T extends JolokiaService<?>> T getService(Class<T> pType) {
        return this.serviceManager.getService(pType);
    }

    @Override
    public <T extends JolokiaService<?>> T getMandatoryService(Class<T> pType) {
        SortedSet<T> services = this.serviceManager.getServices(pType);
        if (services.size() > 1) {
            throw new IllegalStateException("More than one service of type " + String.valueOf(pType) + " found: " + String.valueOf(services));
        }
        if (services.isEmpty()) {
            throw new IllegalStateException("No service of type " + String.valueOf(pType) + " found");
        }
        return (T)((JolokiaService)services.first());
    }

    @Override
    public boolean isDebug() {
        return this.getLog().isDebug() || this.debugStore != null && this.debugStore.isDebug();
    }

    @Override
    public void debug(String message) {
        this.getLog().debug(message);
        if (this.debugStore != null) {
            this.debugStore.log(message);
        }
    }

    @Override
    public void info(String message) {
        this.getLog().info(message);
        if (this.debugStore != null) {
            this.debugStore.log(message);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        this.getLog().error(message, t);
        if (this.debugStore != null) {
            this.debugStore.log(message, t);
        }
    }

    @Override
    public boolean isHttpMethodAllowed(HttpMethod pMethod) {
        return this.getRestrictor().isHttpMethodAllowed(pMethod);
    }

    @Override
    public boolean isTypeAllowed(RequestType pType) {
        return this.getRestrictor().isTypeAllowed(pType);
    }

    @Override
    public boolean isAttributeReadAllowed(ObjectName pName, String pAttribute) {
        return this.getRestrictor().isAttributeReadAllowed(pName, pAttribute);
    }

    @Override
    public boolean isAttributeWriteAllowed(ObjectName pName, String pAttribute) {
        return this.getRestrictor().isAttributeWriteAllowed(pName, pAttribute);
    }

    @Override
    public boolean isOperationAllowed(ObjectName pName, String pOperation) {
        return this.getRestrictor().isOperationAllowed(pName, pOperation);
    }

    @Override
    public boolean isRemoteAccessAllowed(String ... pHostOrAddress) {
        return this.getRestrictor().isRemoteAccessAllowed(pHostOrAddress);
    }

    @Override
    public boolean isOriginAllowed(String pOrigin, boolean pStrictCheck) {
        return this.getRestrictor().isOriginAllowed(pOrigin, pStrictCheck);
    }

    private Configuration getConfiguration() {
        return this.serviceManager.getConfiguration();
    }

    private Restrictor getRestrictor() {
        return this.serviceManager.getRestrictor();
    }

    private LogHandler getLog() {
        return this.serviceManager.getLogHandler();
    }
}

