/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jolokia;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.jolokia.ServerConnectionDescriptor;

public class JolokiaAgentDescriptor
implements ServerConnectionDescriptor {
    private final JMXServiceURL serviceUrl;
    private final Map<String, ?> agentData;

    public JolokiaAgentDescriptor(Map<String, ?> agentData) throws URISyntaxException, MalformedURLException {
        URI uri = new URI((String)agentData.get("url"));
        this.serviceUrl = new JMXServiceURL(String.format("service:jmx:jolokia://%s:%s%s", uri.getHost(), uri.getPort(), uri.getPath()));
        this.agentData = agentData;
    }

    JMXServiceURL getServiceUrl() {
        return this.serviceUrl;
    }

    public String getGUID() {
        return String.valueOf(this.agentData.get("agent_id"));
    }

    public String getDisplayName() {
        return String.valueOf(this.agentData.get("agent_id"));
    }

    public JVMDescriptor getJvmInfo() {
        return null;
    }

    public JMXServiceURL createJMXServiceURL() throws IOException {
        return this.serviceUrl;
    }

    public Map<String, Object> getEnvironment() {
        return new HashMap<String, Object>();
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public JMXServiceURL serviceUrl() {
        return this.serviceUrl;
    }
}

