/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.AggregatableFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.Node;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.StacktraceTreeModel;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.internal.MethodWithFrameType;
import org.openjdk.jmc.flightrecorder.ui.pages.internal.MethodWithFrameTypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.handlers.MethodFormatter;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.PersistableSashForm;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public class MethodProfilingPage
extends AbstractDataPage {
    private static final Color ALTERNATE_COLOR = SWTColorToolkit.getColor((RGB)new RGB(255, 255, 240));
    private static final String COUNT_IMG_KEY = "countColor";
    private static final String SIBLINGS_IMG_KEY = "siblingsColor";
    private static final String PERCENTAGE_COL_ID = "HotMethods.Percentage";
    private static final Color SIBLINGS_COUNT_COLOR = SWTColorToolkit.getColor((RGB)new RGB(170, 250, 170));
    private static final Color COUNT_COLOR = SWTColorToolkit.getColor((RGB)new RGB(100, 200, 100));
    private static final IAttribute<MethodWithFrameType> STACK_TRACE_TOP_METHOD_WITH_FRAME_TYPE = new Attribute<MethodWithFrameType>("(stackTrace).topMethodOptimization", Messages.MethodProfilingPage_METHOD_TITLE, Messages.MethodProfilingPage_METHOD_DESCRIPTION, new ContentType("methodwithframetype", Messages.MethodProfilingPage_METHOD_CONTENT_TYPE_DESCRIPTION)){

        public <U> IMemberAccessor<MethodWithFrameType, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JdkAttributes.STACK_TRACE_TOP_FRAME.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<MethodWithFrameType, U>(){

                public MethodWithFrameType getMember(U i) {
                    IMCFrame frame = (IMCFrame)accessor.getMember(i);
                    return frame == null ? null : new MethodWithFrameType(frame.getMethod(), frame.getType());
                }
            };
        }
    };
    private static final Listener PERCENTAGE_BACKGROUND_DRAWER = new Listener(){

        public void handleEvent(Event event) {
            StacktraceFrame frame = (StacktraceFrame)event.item.getData();
            StacktraceModel.Fork rootFork = MethodProfilingPage.getRootFork(frame.getBranch().getParentFork());
            if (event.index == 2) {
                double d;
                double total = rootFork.getItemsInFork();
                if (d > 0.0) {
                    StacktraceModel.Fork parentFork = frame.getBranch().getParentFork();
                    long forkOffset = parentFork.getItemOffset();
                    int siblingsStart = (int)Math.floor((double)((long)event.width * forkOffset) / total);
                    int siblingsWidth = (int)Math.round((double)(event.width * parentFork.getItemsInFork()) / total);
                    event.gc.setBackground(SIBLINGS_COUNT_COLOR);
                    event.gc.fillRectangle(event.x + siblingsStart, event.y, siblingsWidth, event.height);
                    double offset = (double)(forkOffset + frame.getBranch().getItemOffsetInFork()) / total;
                    double fraction = (double)frame.getItemCount() / total;
                    event.gc.setBackground(COUNT_COLOR);
                    int startPixel = (int)Math.floor((double)event.width * offset);
                    int widthPixel = (int)Math.round((double)event.width * fraction);
                    event.gc.fillRectangle(event.x + startPixel, event.y, Math.max(widthPixel, 1), event.height);
                    event.detail &= 0xFFFFFFF7;
                }
            }
        }
    };
    private static final Listener SUCCESSOR_PERCENTAGE_BACKGROUND_DRAWER = new Listener(){

        public void handleEvent(Event event) {
            SuccessorNode node = (SuccessorNode)event.item.getData();
            if (event.index == 2) {
                double d;
                double total = node.model.root.count;
                if (d > 0.0) {
                    int siblingsStart = 0;
                    int siblingsWidth = (int)Math.round((double)(event.width * node.count) / total);
                    event.gc.setBackground(SIBLINGS_COUNT_COLOR);
                    event.gc.fillRectangle(event.x + siblingsStart, event.y, siblingsWidth, event.height);
                    double fraction = (double)node.count / total;
                    event.gc.setBackground(COUNT_COLOR);
                    int startPixel = 0;
                    int widthPixel = (int)Math.round((double)event.width * fraction);
                    event.gc.fillRectangle(event.x + startPixel, event.y, Math.max(widthPixel, 1), event.height);
                    event.detail &= 0xFFFFFFF7;
                }
            }
        }
    };
    private static final IItemFilter TABLE_ITEMS = ItemFilters.type((String)"jdk.ExecutionSample");
    private static final ItemHistogram.ItemHistogramBuilder HOT_METHODS_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private IItemFilter tableFilter = null;
    private ColumnManager.SelectionState tableSelection;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HOT_METHODS_HISTOGRAM.addCountColumn();
        HOT_METHODS_HISTOGRAM.addPercentageColumn(PERCENTAGE_COL_ID, Aggregators.count(), "Percentage", "Sample percentage over total");
    }

    private static TableSettings getTableSettings(IState state) {
        if (state == null) {
            return new TableSettings("itemhistogram.count", Arrays.asList(new TableSettings.ColumnSettings("itemhistogram.key", Boolean.valueOf(false), Integer.valueOf(500), null), new TableSettings.ColumnSettings("itemhistogram.count", Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(PERCENTAGE_COL_ID, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false))));
        }
        return new TableSettings(state);
    }

    private static Void handleModelBuilException(Throwable ex) {
        FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to build stacktrace view model", ex);
        return null;
    }

    private static boolean isFirstInBranchWithSiblings(StacktraceFrame frame) {
        return frame.getBranch().getFirstFrame() == frame && frame.getBranch().getParentFork().getBranchCount() > 1;
    }

    private static boolean isLastFrame(StacktraceFrame frame) {
        return frame.getBranch().getLastFrame() == frame && frame.getBranch().getEndFork().getBranchCount() == 0;
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new MethodProfilingUi(parent, toolkit, pageContainer, state);
    }

    public MethodProfilingPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return TABLE_ITEMS;
    }

    private static StacktraceModel.Fork getRootFork(StacktraceModel.Fork fork) {
        while (fork.getParentBranch() != null) {
            fork = fork.getParentBranch().getParentFork();
        }
        return fork;
    }

    static /* synthetic */ IItemFilter access$1() {
        return TABLE_ITEMS;
    }

    static /* synthetic */ Void access$3(Throwable throwable) {
        return MethodProfilingPage.handleModelBuilException(throwable);
    }

    private static class CountLabelProvider
    extends ColumnLabelProvider {
        private CountLabelProvider() {
        }

        public String getText(Object element) {
            return Integer.toString(((StacktraceFrame)element).getItemCount());
        }
    }

    private static class CountTreeLabelProvider
    extends ColumnLabelProvider {
        private CountTreeLabelProvider() {
        }

        public String getText(Object element) {
            return Integer.toString(((SuccessorNode)element).count);
        }
    }

    public static class MethodProfilingPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.MethodProfilingPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/method.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"method_profiling"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new MethodProfilingPage(dpd, items, editor);
        }
    }

    private class MethodProfilingUi
    implements IPageUI {
        private static final String METHOD_TABLE = "methodTable";
        private static final String SASH_ELEMENT = "sash";
        private static final String TABLE_ELEMENT = "table";
        private static final String METHOD_FORMAT_KEY = "metodFormat";
        private final ItemHistogram table;
        private final TreeViewer successorTree;
        private final TreeViewer predecessorTree;
        private final SashForm sash;
        private FilterComponent tableFilter;
        private FlavorSelector flavorSelector;
        private MethodFormatter methodFormatter;
        private int[] columnWidths = new int[]{650, 80, 120};

        MethodProfilingUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            Form form = DataPageToolkit.createForm(parent, toolkit, MethodProfilingPage.this.getName(), MethodProfilingPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            this.table = HOT_METHODS_HISTOGRAM.buildWithoutBorder((Composite)this.sash, STACK_TRACE_TOP_METHOD_WITH_FRAME_TYPE, MethodProfilingPage.getTableSettings(state.getChild(TABLE_ELEMENT)), new MethodWithFrameTypeLabelProvider());
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.table.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.table.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.table, Messages.FileIOPage_HISTOGRAM_SELECTION, (IContributionManager)mm);
            this.table.getManager().getViewer().addSelectionChangedListener(e -> this.updateDetails(e));
            this.table.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(this.table.getSelection().getItems()));
            this.tableFilter = FilterComponent.createFilterComponent(this.table, MethodProfilingPage.this.tableFilter, MethodProfilingPage.this.getDataSource().getItems().apply(TABLE_ITEMS), pageContainer.getSelectionStore()::getSelections, this::onTableFilterChange);
            mm.add(this.tableFilter.getShowFilterAction());
            mm.add(this.tableFilter.getShowSearchAction());
            this.tableFilter.loadState(state.getChild(METHOD_TABLE));
            this.methodFormatter = new MethodFormatter(state.getChild(METHOD_FORMAT_KEY), this::refreshTrees);
            CTabFolder tabFolder = new CTabFolder((Composite)this.sash, 0);
            toolkit.adapt((Composite)tabFolder);
            CTabItem t1 = new CTabItem(tabFolder, 0);
            t1.setToolTipText(Messages.MethodProfilingPage_PREDECESSORS_DESCRIPTION);
            this.predecessorTree = this.buildTree((Composite)tabFolder, (IContentProvider)new StacktraceReducedTreeContentProvider());
            t1.setText(Messages.PAGES_PREDECESSORS);
            t1.setControl(this.predecessorTree.getControl());
            this.predecessorTree.getControl().addListener(40, PERCENTAGE_BACKGROUND_DRAWER);
            this.buildColumn(this.predecessorTree, Messages.STACKTRACE_VIEW_STACK_TRACE, 0, this.columnWidths[0]).setLabelProvider((CellLabelProvider)new StackTraceLabelProvider(this.methodFormatter));
            this.buildColumn(this.predecessorTree, Messages.STACKTRACE_VIEW_COUNT_COLUMN_NAME, 131072, this.columnWidths[1]).setLabelProvider((CellLabelProvider)new CountLabelProvider());
            this.buildColumn(this.predecessorTree, Messages.STACKTRACE_VIEW_PERCENTAGE_COLUMN_NAME, 131072, this.columnWidths[2]).setLabelProvider((CellLabelProvider)new PercentageLabelProvider());
            MCContextMenuManager predTreeMenu = MCContextMenuManager.create((Control)this.predecessorTree.getControl());
            predTreeMenu.appendToGroup("group.viewerSetup", (IContributionItem)this.methodFormatter.createMenu());
            CTabItem t2 = new CTabItem(tabFolder, 0);
            t2.setToolTipText(Messages.MethodProfilingPage_SUCCESSORS_DESCRIPTION);
            this.successorTree = this.buildTree((Composite)tabFolder, (IContentProvider)new StacktraceTreeContentProvider());
            t2.setText(Messages.PAGES_SUCCESSORS);
            t2.setControl(this.successorTree.getControl());
            this.successorTree.getControl().addListener(40, SUCCESSOR_PERCENTAGE_BACKGROUND_DRAWER);
            this.successorTree.getControl().addDisposeListener(e -> {
                this.columnWidths = this.getColumnWidths(this.successorTree);
                int[] nArray = this.columnWidths;
            });
            this.buildColumn(this.successorTree, Messages.STACKTRACE_VIEW_STACK_TRACE, 0, this.columnWidths[0]).setLabelProvider((CellLabelProvider)new StackTraceTreeLabelProvider(this.methodFormatter));
            this.buildColumn(this.successorTree, Messages.STACKTRACE_VIEW_COUNT_COLUMN_NAME, 131072, this.columnWidths[1]).setLabelProvider((CellLabelProvider)new CountTreeLabelProvider());
            this.buildColumn(this.successorTree, Messages.STACKTRACE_VIEW_PERCENTAGE_COLUMN_NAME, 131072, this.columnWidths[2]).setLabelProvider((CellLabelProvider)new PercentageTreeLabelProvider());
            MCContextMenuManager succTreeMenu = MCContextMenuManager.create((Control)this.successorTree.getControl());
            succTreeMenu.appendToGroup("group.viewerSetup", (IContributionItem)this.methodFormatter.createMenu());
            tabFolder.setSelection(t1);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(SASH_ELEMENT));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, TABLE_ITEMS, MethodProfilingPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, MethodProfilingPage.this.flavorSelectorState);
            this.table.getManager().setSelectionState(MethodProfilingPage.this.tableSelection);
            MethodProfilingPage.this.addResultActions(form);
        }

        private void refreshTrees() {
            this.predecessorTree.refresh();
            this.successorTree.refresh();
        }

        private TreeViewer buildTree(Composite parent, IContentProvider contentProvider) {
            TreeViewer treeViewer = new TreeViewer(parent, 68354);
            treeViewer.setContentProvider(contentProvider);
            treeViewer.getTree().setHeaderVisible(true);
            treeViewer.getTree().setLinesVisible(true);
            return treeViewer;
        }

        private int[] getColumnWidths(TreeViewer viewer) {
            if (!viewer.getControl().isDisposed()) {
                return Stream.of(viewer.getTree().getColumns()).mapToInt(TreeColumn::getWidth).toArray();
            }
            return this.columnWidths;
        }

        private ViewerColumn buildColumn(TreeViewer viewer, String text, int style, int width) {
            TreeViewerColumn vc = new TreeViewerColumn(viewer, style);
            vc.getColumn().setWidth(width);
            vc.getColumn().setText(text);
            return vc;
        }

        private void onTableFilterChange(IItemFilter filter) {
            this.tableFilter.filterChangeHelper(filter, this.table, MethodProfilingPage.this.getDataSource().getItems().apply(TABLE_ITEMS));
            MethodProfilingPage.this.tableFilter = filter;
        }

        public void saveTo(IWritableState writableState) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)writableState.createChild(SASH_ELEMENT));
            this.methodFormatter.saveState(writableState.createChild(METHOD_FORMAT_KEY));
            this.saveToLocal();
        }

        private void saveToLocal() {
            MethodProfilingPage.this.tableSelection = this.table.getManager().getSelectionState();
            MethodProfilingPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void updateDetails(SelectionChangedEvent event) {
            IItemCollection items = this.table.getSelection().getItems();
            this.predecessorTree.setInput(null);
            this.successorTree.setInput(null);
            this.buildPredecessorTree(items);
            this.buildSuccessorTree(items);
        }

        private void buildPredecessorTree(IItemCollection items) {
            FrameSeparator frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
            StacktraceModel stacktraceModel = new StacktraceModel(false, frameSeparator, items);
            CompletableFuture<StacktraceModel> modelPreparer = this.getModelPreparer(stacktraceModel, false);
            ((CompletableFuture)modelPreparer.thenAcceptAsync(this::setModelPredecessor, DisplayToolkit.inDisplayThread())).exceptionally(MethodProfilingPage::access$3);
        }

        private void setModelPredecessor(StacktraceModel model) {
            if (!this.predecessorTree.getControl().isDisposed()) {
                this.predecessorTree.setInput((Object)model.getRootFork());
            }
        }

        private void buildSuccessorTree(IItemCollection items) {
            CompletableFuture<SuccessorTreeModel> modelPreparer = this.getSuccessorModelPreparer(items);
            ((CompletableFuture)modelPreparer.thenAcceptAsync(this::setModelSuccessor, DisplayToolkit.inDisplayThread())).exceptionally(MethodProfilingPage::access$3);
        }

        private void mergeNode(SuccessorTreeModel model, SuccessorNode destNode, Node srcNode) {
            destNode.count += (int)srcNode.getCumulativeWeight();
            for (Node child : srcNode.getChildren()) {
                String key = SuccessorTreeModel.makeKey((IMCFrame)child.getFrame());
                SuccessorNode existing = destNode.children.putIfAbsent(key, new SuccessorNode(model, destNode, child));
                if (existing == null) continue;
                this.mergeNode(model, existing, child);
            }
        }

        private void traverse(Node current, String typeName, String methodName, SuccessorTreeModel model) {
            if (methodName.equals(current.getFrame().getMethod().getMethodName()) && typeName.equals(current.getFrame().getMethod().getType().getFullName())) {
                if (model.root == null) {
                    model.root = new SuccessorNode(model, null, current);
                }
                this.mergeNode(model, model.root, current);
            }
            for (Node child : current.getChildren()) {
                this.traverse(child, typeName, methodName, model);
            }
        }

        private void setModelSuccessor(SuccessorTreeModel model) {
            if (model == null) {
                return;
            }
            if (!this.successorTree.getControl().isDisposed()) {
                this.successorTree.setInput((Object)model);
            }
        }

        private CompletableFuture<StacktraceModel> getModelPreparer(StacktraceModel model, boolean materializeSelectedBranches) {
            return CompletableFuture.supplyAsync(() -> {
                StacktraceModel.Branch selectedBranch;
                StacktraceModel.Fork root = model.getRootFork();
                if (materializeSelectedBranches && (selectedBranch = this.getLastSelectedBranch(root)) != null) {
                    selectedBranch.getEndFork();
                }
                return model;
            });
        }

        private CompletableFuture<SuccessorTreeModel> getSuccessorModelPreparer(IItemCollection items) {
            return CompletableFuture.supplyAsync(() -> {
                IItemIterable itemIterable;
                IItem execSample = null;
                if (items.hasItems() && (itemIterable = (IItemIterable)items.iterator().next()).hasItems()) {
                    execSample = (IItem)itemIterable.iterator().next();
                }
                if (execSample == null) {
                    return null;
                }
                IMemberAccessor accessor = ItemToolkit.accessor((IAttribute)JfrAttributes.EVENT_STACKTRACE);
                IMCStackTrace stackTrace = (IMCStackTrace)accessor.getMember(execSample);
                String methodName = null;
                String typeName = null;
                if (stackTrace != null && !stackTrace.getFrames().isEmpty()) {
                    IMCFrame topFrame = (IMCFrame)stackTrace.getFrames().get(0);
                    methodName = topFrame.getMethod().getMethodName();
                    typeName = topFrame.getMethod().getType().getFullName();
                }
                if (methodName == null || typeName == null) {
                    return null;
                }
                JdkFilters.MethodFilter methodFilter = new JdkFilters.MethodFilter(typeName, methodName);
                IItemCollection methodEvents = MethodProfilingPage.this.getDataSource().getItems().apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{TABLE_ITEMS, methodFilter}));
                StacktraceTreeModel stacktraceTreeModel = new StacktraceTreeModel(methodEvents);
                SuccessorTreeModel model = new SuccessorTreeModel();
                this.traverse(stacktraceTreeModel.getRoot(), typeName, methodName, model);
                return model;
            });
        }

        private StacktraceModel.Branch getLastSelectedBranch(StacktraceModel.Fork fromFork) {
            StacktraceModel.Branch lastSelectedBranch = null;
            StacktraceModel.Branch branch = fromFork.getSelectedBranch();
            while (branch != null) {
                lastSelectedBranch = branch;
                branch = branch.getEndFork().getSelectedBranch();
            }
            return lastSelectedBranch;
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
        }
    }

    private static class PercentageLabelProvider
    extends ColumnLabelProvider {
        private PercentageLabelProvider() {
        }

        public String getText(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            int itemCount = frame.getItemCount();
            int totalCount = MethodProfilingPage.getRootFork(frame.getBranch().getParentFork()).getItemsInFork();
            return UnitLookup.PERCENT_UNITY.quantity((double)itemCount / (double)totalCount).displayUsing("auto");
        }

        public String getToolTipText(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            StacktraceModel.Fork rootFork = MethodProfilingPage.getRootFork(frame.getBranch().getParentFork());
            int itemCount = frame.getItemCount();
            int totalCount = rootFork.getItemsInFork();
            StacktraceModel.Fork parentFork = frame.getBranch().getParentFork();
            int itemsInSiblings = parentFork.getItemsInFork() - frame.getBranch().getFirstFrame().getItemCount();
            String frameFraction = UnitLookup.PERCENT_UNITY.quantity((double)itemCount / (double)totalCount).displayUsing("auto");
            StringBuilder sb = new StringBuilder("<form>");
            sb.append("<li style='image' value='countColor'><span nowrap='true'>");
            sb.append(Messages.stackTraceMessage(itemCount, totalCount, frameFraction));
            sb.append("</span></li>");
            sb.append("<li style='image' value='siblingsColor'><span nowrap='true'>");
            sb.append(Messages.siblingMessage(itemsInSiblings, parentFork.getBranchCount() - 1));
            sb.append("</span></li>");
            sb.append("</form>");
            return sb.toString();
        }
    }

    private static class PercentageTreeLabelProvider
    extends ColumnLabelProvider {
        private PercentageTreeLabelProvider() {
        }

        public String getText(Object element) {
            SuccessorNode node = (SuccessorNode)element;
            int itemCount = node.count;
            int totalCount = node.model.root.count;
            return UnitLookup.PERCENT_UNITY.quantity((double)itemCount / (double)totalCount).displayUsing("auto");
        }

        public String getToolTipText(Object element) {
            SuccessorNode node = (SuccessorNode)element;
            int itemCount = node.count;
            int totalCount = node.model.root.count;
            String frameFraction = UnitLookup.PERCENT_UNITY.quantity((double)itemCount / (double)totalCount).displayUsing("auto");
            StringBuilder sb = new StringBuilder("<form>");
            sb.append("<li style='image' value='countColor'><span nowrap='true'>");
            sb.append(Messages.stackTraceMessage(itemCount, totalCount, frameFraction));
            sb.append("</span></li>");
            sb.append("</form>");
            return sb.toString();
        }
    }

    private static class StackTraceLabelProvider
    extends ColumnLabelProvider {
        FrameSeparator frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        MethodFormatter methodFormatter;

        public StackTraceLabelProvider(MethodFormatter methodFormatter) {
            this.methodFormatter = methodFormatter;
        }

        public String getText(Object element) {
            IMCFrame frame = ((StacktraceFrame)element).getFrame();
            return this.getText(frame, this.frameSeparator);
        }

        protected String getText(IMCFrame frame, FrameSeparator frameSeparator) {
            return StacktraceFormatToolkit.formatFrame((IMCFrame)frame, (FrameSeparator)frameSeparator, (boolean)this.methodFormatter.showReturnValue(), (boolean)this.methodFormatter.showReturnValuePackage(), (boolean)this.methodFormatter.showClassName(), (boolean)this.methodFormatter.showClassPackageName(), (boolean)this.methodFormatter.showArguments(), (boolean)this.methodFormatter.showArgumentsPackage());
        }

        public Image getImage(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            FlightRecorderUI plugin = FlightRecorderUI.getDefault();
            boolean isFirstInBranch = MethodProfilingPage.isFirstInBranchWithSiblings(frame);
            if (isFirstInBranch) {
                return plugin.getImage("arrow-curved-up.png");
            }
            if (MethodProfilingPage.isLastFrame(frame)) {
                return plugin.getImage("arrow-up-end.png");
            }
            return plugin.getImage("arrow-up.png");
        }

        public Color getBackground(Object element) {
            int parentCount = 0;
            StacktraceModel.Branch e = ((StacktraceFrame)element).getBranch();
            while (e != null) {
                e = e.getParentFork().getParentBranch();
                ++parentCount;
            }
            return parentCount % 2 == 0 ? null : ALTERNATE_COLOR;
        }
    }

    private static class StackTraceTreeLabelProvider
    extends StackTraceLabelProvider {
        public StackTraceTreeLabelProvider(MethodFormatter methodFormatter) {
            super(methodFormatter);
        }

        @Override
        public String getText(Object element) {
            AggregatableFrame frame = ((SuccessorNode)element).frame;
            return this.getText((IMCFrame)frame, this.frameSeparator);
        }

        @Override
        public Image getImage(Object element) {
            FlightRecorderUI plugin = FlightRecorderUI.getDefault();
            SuccessorNode node = (SuccessorNode)element;
            if (this.isFirstInBranchWithSiblings(node)) {
                return plugin.getImage("arrow-curved-up.png");
            }
            if (this.isLastFrame(node)) {
                return plugin.getImage("arrow-up-end.png");
            }
            return plugin.getImage("arrow-up.png");
        }

        private boolean isFirstInBranchWithSiblings(SuccessorNode node) {
            SuccessorNode parent = node.parent;
            if (parent == null) {
                return false;
            }
            return !node.children.isEmpty();
        }

        private boolean isLastFrame(SuccessorNode node) {
            SuccessorNode parent = node.parent;
            if (parent == null) {
                return false;
            }
            SuccessorNode[] children = parent.children.values().toArray(new SuccessorNode[0]);
            if (children.length == 0) {
                return false;
            }
            return children[children.length - 1] == node;
        }

        @Override
        public Color getBackground(Object element) {
            int parentCount = 0;
            SuccessorNode current = ((SuccessorNode)element).parent;
            while (current != null) {
                current = current.parent;
                ++parentCount;
            }
            return parentCount % 2 == 0 ? null : ALTERNATE_COLOR;
        }
    }

    private static class StacktraceReducedTreeContentProvider
    extends AbstractStructuredContentProvider
    implements ITreeContentProvider {
        private StacktraceReducedTreeContentProvider() {
        }

        public StacktraceFrame[] getElements(Object inputElement) {
            StacktraceModel.Fork rootFork = (StacktraceModel.Fork)inputElement;
            if (rootFork.getBranchCount() == 1) {
                StacktraceModel.Branch branch = rootFork.getBranch(0);
                return (StacktraceFrame[])Stream.concat(Stream.concat(Stream.of(branch.getFirstFrame()), Stream.of(branch.getTailFrames())), Stream.of(branch.getEndFork().getFirstFrames())).toArray(StacktraceFrame[]::new);
            }
            return rootFork.getFirstFrames();
        }

        public boolean hasChildren(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            return MethodProfilingPage.isFirstInBranchWithSiblings(frame) && frame.getBranch().hasTail();
        }

        public StacktraceFrame[] getChildren(Object parentElement) {
            Stream<Object> children = Stream.empty();
            StacktraceFrame frame = (StacktraceFrame)parentElement;
            if (MethodProfilingPage.isFirstInBranchWithSiblings(frame)) {
                children = Stream.concat(Stream.of(frame.getBranch().getTailFrames()), Stream.of(frame.getBranch().getEndFork().getFirstFrames()));
            }
            return (StacktraceFrame[])children.toArray(StacktraceFrame[]::new);
        }

        public StacktraceFrame getParent(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            if (MethodProfilingPage.isFirstInBranchWithSiblings(frame) || frame.getBranch().getParentFork().getBranchCount() == 1) {
                StacktraceModel.Branch parentBranch = frame.getBranch().getParentFork().getParentBranch();
                return parentBranch == null ? null : parentBranch.getFirstFrame();
            }
            return frame.getBranch().getFirstFrame();
        }
    }

    private static class StacktraceTreeContentProvider
    extends AbstractStructuredContentProvider
    implements ITreeContentProvider {
        private StacktraceTreeContentProvider() {
        }

        public SuccessorNode[] getElements(Object inputElement) {
            if (inputElement instanceof SuccessorTreeModel) {
                return new SuccessorNode[]{((SuccessorTreeModel)inputElement).root};
            }
            return new SuccessorNode[]{(SuccessorNode)inputElement};
        }

        public SuccessorNode[] getChildren(Object inputElement) {
            return ((SuccessorNode)inputElement).children.values().toArray(new SuccessorNode[0]);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !((SuccessorNode)element).children.isEmpty();
        }
    }

    private static class SuccessorNode {
        final SuccessorTreeModel model;
        final SuccessorNode parent;
        final AggregatableFrame frame;
        final Map<String, SuccessorNode> children = new HashMap<String, SuccessorNode>();
        int count;

        SuccessorNode(SuccessorTreeModel model, SuccessorNode parent, Node node) {
            this.model = model;
            this.parent = parent;
            this.frame = node.getFrame();
            this.count = (int)node.getCumulativeWeight();
        }
    }

    private static class SuccessorTreeModel {
        SuccessorNode root;

        private SuccessorTreeModel() {
        }

        public static String makeKey(IMCFrame frame) {
            return frame.getMethod().getType().getFullName() + "::" + frame.getMethod().getMethodName();
        }
    }
}

