/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.util;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class ThemeUtils {
    private static boolean isCurrentThemeDark;
    private static final double BRIGHTNESS_THRESHOLD = 0.5;

    static {
        ThemeUtils.updateCurrentThemeDarkModeStatus();
        IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equalsIgnoreCase("CONTENT_ASSIST_BACKGROUND_COLOR")) {
                    ThemeUtils.updateCurrentThemeDarkModeStatus();
                }
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(propertyChangeListener);
    }

    public static boolean isDarkTheme() {
        return isCurrentThemeDark;
    }

    private static void updateCurrentThemeDarkModeStatus() {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        RGB backgroundColor = colorRegistry.getRGB("CONTENT_ASSIST_BACKGROUND_COLOR");
        isCurrentThemeDark = backgroundColor == null ? false : ThemeUtils.calculateBrightness(backgroundColor) < 0.5;
    }

    private static double calculateBrightness(RGB color) {
        return Math.sqrt(0.299 * (double)color.red * (double)color.red + 0.587 * (double)color.green * (double)color.green + 0.114 * (double)color.blue * (double)color.blue) / 255.0;
    }
}

