/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.attach.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.openjdk.jmc.browser.attach.BrowserAttachPlugin;
import org.openjdk.jmc.browser.attach.internal.MonitoredVmWrapper;

public class MonitoredHostWrapper {
    public static final String ERROR_MESSAGE_ATTACH = "Could not find attach related classes. This can affect discovery of locally running JVMs.";
    private static Class<?> CLASS_HOST_IDENTIFIER;
    private static Class<?> CLASS_VM_IDENTIFIER;
    static Class<?> CLASS_MONITORED_HOST;
    private Object host;

    static {
        try {
            CLASS_MONITORED_HOST = Class.forName("sun.jvmstat.monitor.MonitoredHost");
            CLASS_HOST_IDENTIFIER = Class.forName("sun.jvmstat.monitor.HostIdentifier");
            CLASS_VM_IDENTIFIER = Class.forName("sun.jvmstat.monitor.VmIdentifier");
        }
        catch (ClassNotFoundException e) {
            CLASS_MONITORED_HOST = null;
            CLASS_HOST_IDENTIFIER = null;
            CLASS_VM_IDENTIFIER = null;
            BrowserAttachPlugin.getPluginLogger().log(Level.WARNING, ERROR_MESSAGE_ATTACH, e);
        }
    }

    public static MonitoredHostWrapper getMonitoredHost() {
        return new MonitoredHostWrapper();
    }

    public MonitoredHostWrapper() {
        if (CLASS_MONITORED_HOST != null) {
            try {
                Object hostIdentifier = this.createHostIdentifier(null);
                Method method = CLASS_MONITORED_HOST.getMethod("getMonitoredHost", CLASS_HOST_IDENTIFIER);
                this.host = method.invoke(null, hostIdentifier);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                BrowserAttachPlugin.getPluginLogger().log(Level.FINEST, "Could not create monitored host. This could make local attach problematic.", e);
            }
        }
    }

    private Object createHostIdentifier(String id) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?> constructor = CLASS_HOST_IDENTIFIER.getConstructor(String.class);
        return constructor.newInstance(id);
    }

    public Set<?> activeVms() {
        if (this.host != null) {
            try {
                Method method = CLASS_MONITORED_HOST.getMethod("activeVms", new Class[0]);
                return (Set)method.invoke(this.host, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                BrowserAttachPlugin.getPluginLogger().log(Level.FINEST, "Problem getting active VMs. This could make local attach problematic.", e);
            }
        }
        return Collections.emptySet();
    }

    public MonitoredVmWrapper getMonitoredVm(String name) {
        if (this.host != null && CLASS_VM_IDENTIFIER != null) {
            try {
                Constructor<?> constructor = CLASS_VM_IDENTIFIER.getConstructor(String.class);
                Object vmIdentifier = constructor.newInstance(name);
                Method getMonitoredVm = CLASS_MONITORED_HOST.getMethod("getMonitoredVm", CLASS_VM_IDENTIFIER);
                Object mvm = getMonitoredVm.invoke(this.host, vmIdentifier);
                if (mvm != null) {
                    return new MonitoredVmWrapper(mvm);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                BrowserAttachPlugin.getPluginLogger().log(Level.FINEST, ERROR_MESSAGE_ATTACH, e);
            }
        }
        return null;
    }
}

