/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.actions;

import java.io.Closeable;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.flightrecorder.configuration.IFlightRecorderService;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.ui.misc.AbstractWarningAction;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class StopRecordingAction
extends AbstractWarningAction {
    private final RecordingProvider recording;

    public StopRecordingAction(RecordingProvider recording) {
        super(Messages.ACTION_STOP_RECORDING_LABEL, Messages.ACTION_STOP_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("jfr_stop.png"));
        this.recording = recording;
    }

    private boolean okToStopDefaultRecording() {
        return DialogToolkit.openQuestionOnUiThread((String)Messages.STOP_RECORDING_TITLE, (String)NLS.bind((String)Messages.STOP_RECORDING_MSG, (Object)this.recording.getRecordingDescriptor().getName()));
    }

    public void doExecute() {
        block6: {
            IRecordingDescriptor recordingDescriptor = this.recording.getRecordingDescriptor();
            if (recordingDescriptor.getId() != 0L || this.okToStopDefaultRecording()) {
                IConnectionHandle connection = null;
                try {
                    try {
                        connection = this.recording.getServerHandle().connect(Messages.ACTION_STOP_RECORDING_TOOLTIP);
                        ((IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class)).stop(recordingDescriptor);
                    }
                    catch (Exception exception) {
                        ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Could not stop recording.");
                        IOToolkit.closeSilently((Closeable)connection);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(connection);
                    throw throwable;
                }
                IOToolkit.closeSilently((Closeable)connection);
            }
        }
    }
}

