/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.attributes;

import javax.management.MBeanServerConnection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataProvider;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.common.subscription.internal.AttributeValueToolkit;
import org.openjdk.jmc.rjmx.services.IAttribute;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.ui.attributes.Messages;
import org.openjdk.jmc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class MRIAttribute
extends ReadOnlyMRIAttribute
implements IAttribute {
    protected MRIAttribute(IConnectionHandle handle, MRI mri) {
        super(handle, mri);
    }

    public void setValue(Object o) {
        try {
            AttributeValueToolkit.setAttribute((MBeanServerConnection)((MBeanServerConnection)this.getHandle().getServiceOrThrow(MBeanServerConnection.class)), (MRI)this.getMRI(), (Object)o);
            this.updateValue(o);
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.MRIAttribute_ERROR_SETTING_ATTRIBUTE_MSG, (Object)this.getMRI().getDataPath());
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)message, (Throwable)e);
        }
    }

    public static ReadOnlyMRIAttribute create(IConnectionHandle handle, MRI mri) {
        boolean editable;
        IMRIMetadata metadata = MRIMetadataToolkit.getMRIMetadata((IConnectionHandle)handle, (MRI)mri);
        boolean bl = editable = metadata != null && MRIMetadataToolkit.isWritable((IMRIMetadataProvider)metadata);
        if (editable) {
            return new MRIAttribute(handle, mri);
        }
        return new ReadOnlyMRIAttribute(handle, mri);
    }
}

