/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataProvider;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.ui.RJMXUIPlugin;
import org.openjdk.jmc.rjmx.ui.internal.MBeanPropertiesOrderer;
import org.openjdk.jmc.ui.common.tree.ITreeNode;

public class MBeanTreeLabelProvider
extends ColumnLabelProvider {
    private final ContentType<?> allowedContentType;

    public MBeanTreeLabelProvider(ContentType<?> allowedContentType) {
        this.allowedContentType = allowedContentType;
    }

    private static Image getConsoleImage(String imageKey) {
        return RJMXUIPlugin.getDefault().getImage(imageKey);
    }

    public Image getImage(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
            return MBeanTreeLabelProvider.getConsoleImage("mbean-16.png");
        }
        if (data instanceof String || data instanceof MBeanPropertiesOrderer.Property) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (data instanceof IMRIMetadata) {
            IMRIMetadata info = (IMRIMetadata)data;
            String unitString = info.getUnitString();
            if (this.allowedContentType != null && unitString != null && !this.allowedContentType.equals((Object)UnitLookup.getContentType((String)unitString))) {
                return null;
            }
            if (MRIMetadataToolkit.isComposite((IMRIMetadataProvider)info)) {
                return MBeanTreeLabelProvider.getConsoleImage("composite-attribute-closed-16.png");
            }
            if (MRIMetadataToolkit.isNumerical((IMRIMetadata)info)) {
                return MBeanTreeLabelProvider.getConsoleImage("numerical-attribute-16.png");
            }
            return MBeanTreeLabelProvider.getConsoleImage("non-numerical-attribute-16.png");
        }
        throw new IllegalArgumentException("This label provider only supports the ObjectName and AttributeInfo types.");
    }

    public String getText(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof MBeanPropertiesOrderer.Property) {
            return MBeanTreeLabelProvider.formatProperty((MBeanPropertiesOrderer.Property)data);
        }
        if (data instanceof IMRIMetadata) {
            String dataPath = ((IMRIMetadata)data).getMRI().getDataPath();
            return dataPath.substring(dataPath.lastIndexOf(47) + 1);
        }
        throw new IllegalArgumentException("This label provider only supports the ObjectName and AttributeInfo types: " + String.valueOf(data));
    }

    public Font getFont(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof IMRIMetadata && MRIMetadataToolkit.isNumerical((IMRIMetadata)((IMRIMetadata)data)) && ((IMRIMetadata)data).getUnitString() == null) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return super.getFont(element);
    }

    public Color getForeground(Object element) {
        String unitString;
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof IMRIMetadata && this.allowedContentType != null && (unitString = ((IMRIMetadata)data).getUnitString()) != null && !this.allowedContentType.equals((Object)UnitLookup.getContentType((String)unitString))) {
            return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }
        return super.getForeground(element);
    }

    public String getToolTipText(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
            return MBeanPropertiesOrderer.getMBeanPath(((MBeanPropertiesOrderer.PropertyWithMBean)data).getBean());
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof MBeanPropertiesOrderer.Property) {
            return ((MBeanPropertiesOrderer.Property)data).getStringRepresentation();
        }
        if (data instanceof IMRIMetadata) {
            return ((IMRIMetadata)data).getDescription();
        }
        return null;
    }

    private static String formatProperty(MBeanPropertiesOrderer.Property data) {
        String value = data.getValue();
        if (value != null && "class".equals(data.getKey())) {
            return value.substring(value.lastIndexOf(46) + 1);
        }
        return value;
    }
}

