/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.batch;

import java.util.List;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.support.RefChainElementImpl;

public class ExtendedField
implements RefChainElement {
    private final List<RefChainElement> fieldAndExt;
    private final String valueAsString;

    @Override
    public JavaClass getJavaClass() {
        return this.fieldAndExt.get(0).getJavaClass();
    }

    @Override
    public RefChainElement getReferer() {
        return null;
    }

    ExtendedField(List<RefChainElement> fieldAndExt) {
        this.fieldAndExt = fieldAndExt;
        this.valueAsString = this.valueAsString();
    }

    public RefChainElement toReferenceChain() {
        RefChainElementImpl.AbstractField referer = null;
        for (RefChainElement curElement : this.fieldAndExt) {
            RefChainElementImpl.AbstractElement newElement;
            if (curElement instanceof RefChainElementImpl.InstanceFieldOrLinkedList) {
                field = (RefChainElementImpl.InstanceFieldOrLinkedList)curElement;
                newElement = RefChainElementImpl.createInstanceFieldOrLinkedListElementInFinalForm(((RefChainElementImpl.InstanceFieldOrLinkedList)field).getJavaClass(), field.getFieldIdx(), referer, ((RefChainElementImpl.InstanceFieldOrLinkedList)field).isInstanceField());
            } else if (curElement instanceof RefChainElementImpl.StaticField) {
                field = (RefChainElementImpl.StaticField)curElement;
                newElement = RefChainElementImpl.createStaticFieldElementInFinalForm(((RefChainElementImpl.StaticField)field).getJavaClass(), field.getFieldIdx(), referer);
            } else if (curElement instanceof RefChainElementImpl.Collection) {
                RefChainElementImpl.Collection col = (RefChainElementImpl.Collection)curElement;
                newElement = RefChainElementImpl.createCompoundCollectionElementInFinalForm(col.getJavaClass(), referer);
            } else if (curElement instanceof RefChainElementImpl.Array) {
                RefChainElementImpl.Array ar = (RefChainElementImpl.Array)curElement;
                newElement = RefChainElementImpl.createCompoundArrayElementInFinalForm(ar.getJavaClass(), referer);
            } else {
                throw new RuntimeException("Unsupported ref chain element type: " + String.valueOf(curElement.getClass()));
            }
            referer = newElement;
        }
        return referer;
    }

    public String toString() {
        return this.valueAsString;
    }

    private String valueAsString() {
        if (this.fieldAndExt.size() == 1) {
            return this.fieldAndExt.get(0).toString();
        }
        StringBuilder sb = new StringBuilder(32);
        for (RefChainElement ext : this.fieldAndExt) {
            sb.append(ext.toString());
            sb.append("-->");
        }
        return sb.toString();
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof ExtendedField)) {
            return false;
        }
        ExtendedField other = (ExtendedField)otherObj;
        return this.valueAsString.equals(other.valueAsString);
    }

    public int hashCode() {
        return this.valueAsString.hashCode();
    }

    @Override
    public boolean shallowEquals(Object other) {
        return this.equals(other);
    }

    @Override
    public int shallowHashCode() {
        return this.hashCode();
    }
}

