/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.util;

import java.util.HashMap;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaField;
import org.openjdk.jmc.joverflow.support.Constants;

public class ClassUtils
implements Constants {
    private static final HashMap<String, String> POPULAR_CLASS_SHORT_NAMES = new HashMap();
    private static final String[] POPULAR_PACKAGES = new String[]{"java.lang.", "java.util.", "java.util.concurrent.", "java.lang.ref."};

    public static String getExactFieldName(String oneOrMoreFieldNames, JavaClass clazz) {
        int splitIdx = oneOrMoreFieldNames.indexOf(124);
        if (splitIdx != -1) {
            int startIdx = 0;
            while (true) {
                String fieldName;
                if (clazz.getDeclaringClassForField(fieldName = oneOrMoreFieldNames.substring(startIdx, splitIdx)) != null) {
                    return fieldName;
                }
                startIdx = splitIdx + 1;
                if (startIdx >= oneOrMoreFieldNames.length()) break;
                splitIdx = oneOrMoreFieldNames.indexOf(124, startIdx);
                if (splitIdx != -1) continue;
                splitIdx = oneOrMoreFieldNames.length();
            }
            throw new RuntimeException(ClassUtils.getMessageForMissingField(clazz, oneOrMoreFieldNames));
        }
        if (clazz.getDeclaringClassForField(oneOrMoreFieldNames) == null) {
            throw new RuntimeException(ClassUtils.getMessageForMissingField(clazz, oneOrMoreFieldNames));
        }
        return oneOrMoreFieldNames;
    }

    public static String getMessageForMissingField(JavaClass clazz, String fieldName) {
        JavaField[] fieldDescs = clazz.getFieldsForInstance();
        StringBuilder msg = new StringBuilder();
        msg.append(clazz.getName()).append(": field ").append(fieldName).append(" not found.\n");
        msg.append("Existing fields:\n");
        JavaField[] javaFieldArray = fieldDescs;
        int n = fieldDescs.length;
        int n2 = 0;
        while (n2 < n) {
            JavaField fieldDesc = javaFieldArray[n2];
            msg.append(fieldDesc.getTypeId()).append(' ').append(fieldDesc.getName()).append('\n');
            ++n2;
        }
        return msg.toString();
    }

    public static String getShortNameForPopularClass(String className) {
        String shortName = POPULAR_CLASS_SHORT_NAMES.get(className);
        if (shortName != null) {
            return shortName;
        }
        String[] stringArray = POPULAR_PACKAGES;
        int n = POPULAR_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            int lastDotIdx;
            String pkg = stringArray[n2];
            if (className.startsWith(pkg) && (lastDotIdx = className.lastIndexOf(46)) == pkg.length() - 1) {
                shortName = className.substring(lastDotIdx + 1);
                POPULAR_CLASS_SHORT_NAMES.put(className, shortName);
                return shortName;
            }
            ++n2;
        }
        return className;
    }

    public static boolean isAnonymousInnerClass(String className) {
        if (!Character.isDigit(className.charAt(className.length() - 1))) {
            return false;
        }
        int dollarIdx = className.lastIndexOf(36);
        if (dollarIdx == -1) {
            return false;
        }
        return Character.isDigit(className.charAt(dollarIdx + 1));
    }

    public static String arrayOf(String className) {
        return "[L" + className + ";";
    }
}

