/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.util;

public abstract class NumberToIntMap {
    protected int[] values;
    protected int size;
    protected int capacity;
    protected int threshold;
    protected long rehashTime;

    protected NumberToIntMap(int expectedMaxSize) {
        if (expectedMaxSize < 11) {
            expectedMaxSize = 11;
        }
        this.capacity = 4 * expectedMaxSize / 3;
        this.createTable();
    }

    public abstract void put(long var1, int var3);

    public abstract int get(long var1);

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void adjustCapacityIfNeeded() {
        int optimalCapacity = 4 * this.size / 3 + 10 | 1;
        int avgCapacityValue = (optimalCapacity + this.capacity) / 2;
        if ((double)Math.abs(optimalCapacity - this.capacity) / (double)avgCapacityValue > 0.1) {
            this.rehash(optimalCapacity);
        }
    }

    protected void finishPut() {
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash(this.capacity * 3 / 2 | 1);
        }
    }

    protected final int nextKeyIndex(int idx) {
        int nextIdx = idx + 1;
        return nextIdx < this.capacity ? nextIdx : 0;
    }

    protected abstract void rehash(int var1);

    protected abstract void createTable();

    public long getRehashTimeMillis() {
        return this.rehashTime;
    }
}

