/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.internal;

import javax.management.MBeanServerConnection;
import org.openjdk.jmc.rjmx.common.ConnectionException;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.common.services.ICommercialFeaturesService;
import org.openjdk.jmc.rjmx.common.services.IDiagnosticCommandService;
import org.openjdk.jmc.rjmx.common.services.internal.CommercialFeaturesServiceUtil;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.HotspotManagementToolkit;

public class HotSpot23CommercialFeaturesService
implements ICommercialFeaturesService {
    private static final String UNLOCK_COMMERCIAL_FEATURES_FLAG = "UnlockCommercialFeatures";
    private static final String UNLOCK_COMMAND = "VM.unlock_commercial_features";
    private final MBeanServerConnection server;
    private final IDiagnosticCommandService dcs;

    public HotSpot23CommercialFeaturesService(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        block2: {
            this.server = handle.getServiceOrThrow(MBeanServerConnection.class);
            this.dcs = handle.getServiceOrNull(IDiagnosticCommandService.class);
            try {
                HotspotManagementToolkit.getVMOption(this.server, UNLOCK_COMMERCIAL_FEATURES_FLAG);
            }
            catch (Exception e) {
                if (CommercialFeaturesServiceUtil.isJfrMBeanAvailable(this.server)) break block2;
                throw new ServiceNotAvailableException("");
            }
        }
    }

    @Override
    public boolean isCommercialFeaturesEnabled() {
        try {
            return ((String)HotspotManagementToolkit.getVMOption(this.server, UNLOCK_COMMERCIAL_FEATURES_FLAG)).contains("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void enableCommercialFeatures() throws Exception {
        if (this.dcs != null) {
            this.dcs.runCtrlBreakHandlerWithResult(UNLOCK_COMMAND);
        }
        if (!this.isCommercialFeaturesEnabled()) {
            HotspotManagementToolkit.setVMOption(this.server, UNLOCK_COMMERCIAL_FEATURES_FLAG, "true");
        }
    }

    @Override
    public boolean hasCommercialFeatures() {
        return true;
    }
}

