/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.subscription.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.openjdk.jmc.rjmx.common.ConnectionException;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.common.subscription.IMBeanHelperService;
import org.openjdk.jmc.rjmx.common.subscription.IMBeanServerChangeListener;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.common.subscription.internal.AbstractAttributeSubscription;
import org.openjdk.jmc.rjmx.common.subscription.internal.UnavailableChildSubscriptions;

public class UnavailableSubscriptionsRepository {
    private final IConnectionHandle m_connectionHandle;
    private final IMBeanHelperService m_helperService;
    private final IMBeanServerChangeListener m_mbeanServerChangeListener;
    private final Set<ObjectName> m_unregisteredMBeans = new HashSet<ObjectName>();
    private final Map<ObjectName, Set<AbstractAttributeSubscription>> m_unregisteredSubscriptions = new HashMap<ObjectName, Set<AbstractAttributeSubscription>>();
    private final Map<MRI, UnavailableChildSubscriptions> m_unavailableChildSubscriptions = new HashMap<MRI, UnavailableChildSubscriptions>();
    private final Map<AbstractAttributeSubscription, BackoffTimeInformation> m_possibleSubscriptions = new HashMap<AbstractAttributeSubscription, BackoffTimeInformation>();

    public UnavailableSubscriptionsRepository(IConnectionHandle connectionHandle) throws ConnectionException, ServiceNotAvailableException {
        this.m_connectionHandle = connectionHandle;
        this.m_helperService = connectionHandle.getServiceOrThrow(IMBeanHelperService.class);
        this.m_mbeanServerChangeListener = this.createMBeanServerChangeListener();
        this.getMBeanHelperService().addMBeanServerChangeListener(this.m_mbeanServerChangeListener);
    }

    public void dispose() {
        this.getMBeanHelperService().removeMBeanServerChangeListener(this.m_mbeanServerChangeListener);
        this.m_unregisteredMBeans.clear();
    }

    private IMBeanHelperService getMBeanHelperService() {
        return this.m_helperService;
    }

    private IMBeanServerChangeListener createMBeanServerChangeListener() {
        return new IMBeanServerChangeListener(){

            @Override
            public void mbeanUnregistered(ObjectName mbean) {
                if (this.unregisterMBean(mbean)) {
                    UnavailableSubscriptionsRepository.this.moveUnregisteredMBeanSubscriptions(mbean);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean unregisterMBean(ObjectName mbean) {
                Set<ObjectName> set = UnavailableSubscriptionsRepository.this.m_unregisteredMBeans;
                synchronized (set) {
                    return UnavailableSubscriptionsRepository.this.m_unregisteredMBeans.add(mbean);
                }
            }

            @Override
            public void mbeanRegistered(ObjectName mbean) {
                if (this.registerMBean(mbean)) {
                    UnavailableSubscriptionsRepository.this.moveRegisteredMBeanSubscriptions(mbean);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean registerMBean(ObjectName mbean) {
                Set<ObjectName> set = UnavailableSubscriptionsRepository.this.m_unregisteredMBeans;
                synchronized (set) {
                    return UnavailableSubscriptionsRepository.this.m_unregisteredMBeans.remove(mbean);
                }
            }
        };
    }

    synchronized void movePossibleChildSubscriptions(UnavailableChildSubscriptions possibleChildSubscriptions) {
        this.m_unavailableChildSubscriptions.remove(possibleChildSubscriptions.getParentMRI());
        for (AbstractAttributeSubscription subscription : possibleChildSubscriptions.getChildSubscriptions()) {
            this.m_possibleSubscriptions.put(subscription, new BackoffTimeInformation());
        }
    }

    private synchronized void moveRegisteredMBeanSubscriptions(ObjectName mbean) {
        Set<AbstractAttributeSubscription> subscriptions = this.m_unregisteredSubscriptions.remove(mbean);
        if (subscriptions != null) {
            for (AbstractAttributeSubscription subscription : subscriptions) {
                this.m_possibleSubscriptions.put(subscription, new BackoffTimeInformation());
            }
        }
    }

    private synchronized void moveUnregisteredMBeanSubscriptions(ObjectName mbean) {
        for (AbstractAttributeSubscription subscription : this.getPossibleSubscriptions()) {
            if (!subscription.getMRIMetadata().getMRI().getObjectName().equals(mbean)) continue;
            this.m_possibleSubscriptions.remove(subscription);
            this.getUnregisteredSubscriptions(mbean).add(subscription);
        }
    }

    private Set<AbstractAttributeSubscription> getUnregisteredSubscriptions(ObjectName mbean) {
        Set<AbstractAttributeSubscription> subscriptions = this.m_unregisteredSubscriptions.get(mbean);
        if (subscriptions == null) {
            subscriptions = new HashSet<AbstractAttributeSubscription>();
            this.m_unregisteredSubscriptions.put(mbean, subscriptions);
        }
        return subscriptions;
    }

    private Collection<AbstractAttributeSubscription> getPossibleSubscriptions() {
        return new ArrayList<AbstractAttributeSubscription>(this.m_possibleSubscriptions.keySet());
    }

    public synchronized Collection<AbstractAttributeSubscription> getBackoffedSubscriptions() {
        ArrayList<AbstractAttributeSubscription> subscriptions = new ArrayList<AbstractAttributeSubscription>();
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<AbstractAttributeSubscription, BackoffTimeInformation> entry : this.m_possibleSubscriptions.entrySet()) {
            BackoffTimeInformation info = entry.getValue();
            if (info.lastTestTime + info.backoffTime >= currentTime) continue;
            info.lastTestTime = currentTime;
            info.backoffTime *= 2L;
            subscriptions.add(entry.getKey());
        }
        return subscriptions;
    }

    private synchronized Collection<AbstractAttributeSubscription> getUnregisteredSubscriptions() {
        ArrayList<AbstractAttributeSubscription> subscriptions = new ArrayList<AbstractAttributeSubscription>();
        for (Set<AbstractAttributeSubscription> mbeanSubscriptions : this.m_unregisteredSubscriptions.values()) {
            subscriptions.addAll(mbeanSubscriptions);
        }
        return subscriptions;
    }

    public synchronized Collection<AbstractAttributeSubscription> getAllSubscriptions() {
        Collection<AbstractAttributeSubscription> subscriptions = this.getUnregisteredSubscriptions();
        subscriptions.addAll(this.getUnavailableChildSubscriptions());
        subscriptions.addAll(this.getPossibleSubscriptions());
        return subscriptions;
    }

    private synchronized Collection<AbstractAttributeSubscription> getUnavailableChildSubscriptions() {
        ArrayList<AbstractAttributeSubscription> subscriptions = new ArrayList<AbstractAttributeSubscription>();
        for (UnavailableChildSubscriptions unavailableChildSubscriptions : this.m_unavailableChildSubscriptions.values()) {
            subscriptions.addAll(unavailableChildSubscriptions.getChildSubscriptions());
        }
        return subscriptions;
    }

    public synchronized boolean add(AbstractAttributeSubscription subscription) {
        ObjectName mbean = subscription.getMRIMetadata().getMRI().getObjectName();
        if (this.isMBeanUnregistered(mbean)) {
            return this.getUnregisteredSubscriptions(mbean).add(subscription);
        }
        if (UnavailableChildSubscriptions.isCompositeChildSubscription(subscription)) {
            return this.getUnavailableSubscriptions(subscription).addChildSubscription(subscription);
        }
        return this.m_possibleSubscriptions.put(subscription, new BackoffTimeInformation()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMBeanUnregistered(ObjectName mbean) {
        Set<ObjectName> set = this.m_unregisteredMBeans;
        synchronized (set) {
            return this.m_unregisteredMBeans.contains(mbean);
        }
    }

    private UnavailableChildSubscriptions getUnavailableSubscriptions(AbstractAttributeSubscription subscription) {
        MRI parentMRI = UnavailableChildSubscriptions.getParentMRI(subscription);
        UnavailableChildSubscriptions unavailableChildSubscriptions = this.m_unavailableChildSubscriptions.get(parentMRI);
        if (unavailableChildSubscriptions == null) {
            unavailableChildSubscriptions = new UnavailableChildSubscriptions(this.m_connectionHandle, parentMRI, this);
            this.m_unavailableChildSubscriptions.put(parentMRI, unavailableChildSubscriptions);
        }
        return unavailableChildSubscriptions;
    }

    public synchronized boolean remove(AbstractAttributeSubscription subscription) {
        return this.m_possibleSubscriptions.remove(subscription) != null || this.hasUnavilableChildSubscription(subscription) || this.getUnregisteredSubscriptions(subscription.getMRIMetadata().getMRI().getObjectName()).remove(subscription);
    }

    private boolean hasUnavilableChildSubscription(AbstractAttributeSubscription subscription) {
        MRI parentMRI;
        UnavailableChildSubscriptions unavailableChildSubscriptions;
        if (UnavailableChildSubscriptions.isCompositeChildSubscription(subscription) && (unavailableChildSubscriptions = this.m_unavailableChildSubscriptions.get(parentMRI = UnavailableChildSubscriptions.getParentMRI(subscription))) != null) {
            return this.removeSubscription(unavailableChildSubscriptions, subscription, parentMRI);
        }
        return false;
    }

    private boolean removeSubscription(UnavailableChildSubscriptions unavailableChildSubscriptions, AbstractAttributeSubscription subscription, MRI parentMRI) {
        boolean result = unavailableChildSubscriptions.getChildSubscriptions().remove(subscription);
        if (unavailableChildSubscriptions.getChildSubscriptions().size() == 0) {
            unavailableChildSubscriptions.dispose();
            this.m_unavailableChildSubscriptions.remove(parentMRI);
        }
        return result;
    }

    public synchronized boolean contains(MRI mri) {
        for (AbstractAttributeSubscription subscription : this.getAllSubscriptions()) {
            if (!mri.equals(subscription.getMRIMetadata().getMRI())) continue;
            return true;
        }
        return false;
    }

    private static class BackoffTimeInformation {
        private long backoffTime;
        private long lastTestTime;

        public BackoffTimeInformation() {
            this(1000L, System.currentTimeMillis());
        }

        public BackoffTimeInformation(long backoff, long lastTest) {
            this.backoffTime = backoff;
            this.lastTestTime = lastTest;
        }
    }
}

