/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataProviderService;
import org.openjdk.jmc.rjmx.subscription.internal.FileMRIMetadata;
import org.openjdk.jmc.rjmx.subscription.internal.MRIMetadataWrapper;

public final class FileMRIMetadataDB
extends Observable
implements IStateful,
IMRIMetadataService {
    private static final String ELEMENT_MAP_ENTRY = "mapEntry";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_KEY = "key";
    private final Map<MRI, Map<String, Object>> metadataMap;
    private final Map<MRI, Map<String, String>> changedMetadataStore;
    private final IMRIMetadataProviderService subService;

    private FileMRIMetadataDB(Map<MRI, Map<String, String>> changedMetadataStore, IMRIMetadataProviderService subService) {
        this.changedMetadataStore = changedMetadataStore;
        this.metadataMap = FileMRIMetadata.readDefaultsFromFile();
        this.subService = subService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadata(MRI mri, String key, String value) {
        Map<MRI, Map<String, String>> map = this.changedMetadataStore;
        synchronized (map) {
            this.changedMetadataStore.computeIfAbsent(mri, k -> new HashMap()).put(key, value);
        }
        this.setChanged();
        this.notifyObservers(mri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMetadata(MRI mri, String dataKey) {
        Map metadataForMri;
        Map<String, Object> mriMetadataMap;
        Map<MRI, Map<String, String>> map = this.changedMetadataStore;
        synchronized (map) {
            mriMetadataMap = this.changedMetadataStore.get(mri);
            if (mriMetadataMap != null && mriMetadataMap.containsKey(dataKey)) {
                return mriMetadataMap.get(dataKey);
            }
        }
        mriMetadataMap = this.metadataMap;
        synchronized (mriMetadataMap) {
            metadataForMri = this.metadataMap.computeIfAbsent(mri, k -> new HashMap(2));
            Object metadata = metadataForMri.get(dataKey);
            if (metadata != null) {
                return metadata;
            }
        }
        Object metadata = this.subService.getMetadata(this, mri, dataKey);
        Map<MRI, Map<String, Object>> map2 = this.metadataMap;
        synchronized (map2) {
            metadataForMri.put(dataKey, metadata);
        }
        return metadata;
    }

    public IMRIMetadata getMetadata(MRI mri) {
        return new MRIMetadataWrapper(mri, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(IWritableState state) {
        Map<MRI, Map<String, String>> map = this.changedMetadataStore;
        synchronized (map) {
            for (Map.Entry<MRI, Map<String, String>> mriEntry : this.changedMetadataStore.entrySet()) {
                IWritableState mriChild = state.createChild(ELEMENT_MAP_ENTRY);
                mriChild.putString(ATTRIBUTE_KEY, mriEntry.getKey().getQualifiedName());
                for (Map.Entry<String, String> dataEntry : mriEntry.getValue().entrySet()) {
                    IWritableState dataChild = mriChild.createChild(ELEMENT_MAP_ENTRY);
                    dataChild.putString(ATTRIBUTE_KEY, dataEntry.getKey());
                    dataChild.putString(ATTRIBUTE_VALUE, dataEntry.getValue());
                }
            }
        }
    }

    public static FileMRIMetadataDB buildFromState(IState state, IMRIMetadataProviderService subService) throws RuntimeException {
        HashMap<MRI, Map<String, String>> metadata = new HashMap<MRI, Map<String, String>>();
        IState[] iStateArray = state.getChildren();
        int n = iStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            IState mriElement = iStateArray[n2];
            MRI mri = MRI.createFromQualifiedName((String)mriElement.getAttribute(ATTRIBUTE_KEY));
            HashMap<String, String> data = new HashMap<String, String>();
            IState[] iStateArray2 = mriElement.getChildren();
            int n3 = iStateArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IState dataElement = iStateArray2[n4];
                data.put(dataElement.getAttribute(ATTRIBUTE_KEY), dataElement.getAttribute(ATTRIBUTE_VALUE));
                ++n4;
            }
            metadata.put(mri, data);
            ++n2;
        }
        return new FileMRIMetadataDB(metadata, subService);
    }

    public static FileMRIMetadataDB buildDefault(IMRIMetadataProviderService subService) {
        return new FileMRIMetadataDB(new HashMap<MRI, Map<String, String>>(), subService);
    }
}

