/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ColumnLayout
extends Layout {
    private static final int MARGIN = 4;
    private static final int SPACING = 2;
    private Point[] sizes;
    private int maxWidth;
    private int totalHeight;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        if (flushCache || this.sizes == null || this.sizes.length != children.length) {
            this.initialize(children);
        }
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = this.maxWidth;
        }
        if (hHint == -1) {
            height = this.totalHeight;
        }
        return new Point(width + 8, height + 8);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        if (flushCache || this.sizes == null || this.sizes.length != children.length) {
            this.initialize(children);
        }
        Rectangle rect = composite.getClientArea();
        int y = 4;
        int width = Math.max(rect.width - 8, this.maxWidth);
        int i = 0;
        while (i < children.length) {
            int height = this.sizes[i].y;
            children[i].setBounds(4, y, width, height);
            y += height + 2;
            ++i;
        }
    }

    private void initialize(Control[] children) {
        this.maxWidth = 0;
        this.totalHeight = 0;
        this.sizes = new Point[children.length];
        int i = 0;
        while (i < children.length) {
            this.sizes[i] = children[i].computeSize(-1, -1, true);
            this.maxWidth = Math.max(this.maxWidth, this.sizes[i].x);
            this.totalHeight += this.sizes[i].y;
            ++i;
        }
        this.totalHeight += (children.length - 1) * 2;
    }
}

