/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.joverflow.ui.swt.ArcItem;

public class PieChart
extends Canvas {
    private static final int MARGIN = 5;
    private double mZoomRatio = 1.0;
    private final List<ArcItem> mArcs = new ArrayList<ArcItem>();
    private ArcItem mHighlightedItem;

    public PieChart(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.setLayout((Layout)new FillLayout());
        this.addPaintListener(e -> {
            e.gc.setAntialias(1);
            int x = this.getClientArea().width / 2;
            int y = this.getClientArea().height / 2;
            Point center = new Point(x, y);
            int radius = Math.min(x, y) - 5;
            radius = (int)((double)radius / this.mZoomRatio);
            if (radius < 0) {
                radius = 0;
            }
            int startAngle = 0;
            Color background = e.gc.getBackground();
            for (ArcItem item : this.mArcs) {
                e.gc.setBackground(background);
                if (this.mHighlightedItem == item) {
                    item.paintArc(e.gc, center, radius, startAngle, this.mZoomRatio, (style & 0x800) == 2048);
                } else {
                    item.paintArc(e.gc, center, radius, startAngle, 1.0, (style & 0x800) == 2048);
                }
                startAngle += item.getAngle();
            }
            if (startAngle < 360 && (style & 0x800) == 2048) {
                e.gc.drawArc(center.x - radius, center.y - radius, radius * 2, radius * 2, startAngle, 360 - startAngle);
            }
        });
        this.addListener(11, e -> this.redraw());
        this.addMouseMoveListener(e -> this.setHighlightedItem(this.getItem(new Point(e.x, e.y))));
    }

    void createItem(ArcItem arc, int i) {
        if (i < 0 || i > this.mArcs.size()) {
            SWT.error((int)6);
            return;
        }
        if (i == this.mArcs.size()) {
            this.mArcs.add(arc);
            return;
        }
        this.mArcs.get(i).dispose();
        this.mArcs.set(i, arc);
    }

    public int getItemCount() {
        return this.mArcs.size();
    }

    public ArcItem[] getItems() {
        return this.mArcs.toArray(new ArcItem[0]);
    }

    public ArcItem getItemByAngle(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        int startAngle = 0;
        for (ArcItem item : this.mArcs) {
            if (angle > startAngle && angle < startAngle + item.getAngle()) {
                return item;
            }
            startAngle += item.getAngle();
        }
        return null;
    }

    public ArcItem getItem(Point point) {
        ArcItem item;
        int x = this.getClientArea().width / 2;
        int y = this.getClientArea().height / 2;
        int radius = Math.min(x, y) - 5;
        if ((radius = (int)((double)radius / this.mZoomRatio)) < 0) {
            radius = 0;
        }
        if ((item = this.getItemByAngle((int)Math.toDegrees(Math.atan2(y -= point.y, x = point.x - x)))) == null) {
            return null;
        }
        if (item == this.mHighlightedItem && Math.sqrt(x * x + y * y) < (double)radius * this.mZoomRatio) {
            return item;
        }
        if (Math.sqrt(x * x + y * y) < (double)radius) {
            return item;
        }
        return null;
    }

    public ArcItem getItem(int index) {
        return this.mArcs.get(index);
    }

    public int indexOf(ArcItem item) {
        return this.mArcs.indexOf((Object)item);
    }

    public void removeItem(int index) {
        this.mArcs.get(index).dispose();
        this.mArcs.remove(index);
    }

    public void setZoomRatio(double ratio) {
        this.mZoomRatio = ratio;
    }

    public ArcItem getHighlightedItem() {
        return this.mHighlightedItem;
    }

    public int getHighlightedItemIndex() {
        return this.indexOf(this.mHighlightedItem);
    }

    public void setHighlightedItem(ArcItem item) {
        ArcItem oldItem = this.mHighlightedItem;
        if (item != null && !this.mArcs.contains((Object)item)) {
            throw new IllegalArgumentException("invalid item");
        }
        this.mHighlightedItem = item;
        if (this.mHighlightedItem != oldItem) {
            this.redraw();
        }
    }
}

